/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DRCTemplate
implements Serializable {
    public static final DRCTemplateSort templateSort = new DRCTemplateSort();
    public String ruleName;
    public int when;
    public DRCRuleType ruleType;
    public String name1;
    public String name2;
    public double[] values;
    public double maxWidth;
    public double minLength;
    public String nodeName;
    public int multiCuts;

    private void copyValues(double[] vals) {
        int len = vals.length;
        assert (len == 1 || len == 2);
        this.values = new double[len];
        System.arraycopy(vals, 0, this.values, 0, len);
    }

    public double getValue(int i) {
        return this.values[i];
    }

    public void setValue(int i, double val) {
        this.values[i] = val;
    }

    public DRCTemplate(DRCTemplate rule) {
        this.ruleName = rule.ruleName;
        this.when = rule.when;
        this.ruleType = rule.ruleType;
        this.name1 = rule.name1;
        this.name2 = rule.name2;
        this.copyValues(rule.values);
        this.maxWidth = rule.maxWidth;
        this.minLength = rule.minLength;
        this.nodeName = rule.nodeName;
        this.multiCuts = rule.multiCuts;
    }

    public DRCTemplate(String rule, int when, DRCRuleType ruleType, String name1, String name2, double[] vals, String nodeName) {
        this.ruleName = rule;
        this.when = when;
        this.ruleType = ruleType;
        this.name1 = name1;
        this.name2 = name2;
        this.copyValues(vals);
        this.nodeName = nodeName;
        this.multiCuts = -1;
        switch (ruleType) {
            case SPACING: 
            case SURROUND: {
                if (name1 != null && name2 != null) break;
                System.out.println("Error: missing one layer in no '" + rule + "' ");
                break;
            }
        }
    }

    public DRCTemplate(String rule, int when, DRCRuleType ruleType, double maxW, double minLen, double[] vals, int multiCut) {
        this.ruleName = rule;
        this.when = when;
        this.ruleType = ruleType;
        this.copyValues(vals);
        this.maxWidth = maxW;
        this.minLength = minLen;
        this.multiCuts = multiCut;
    }

    public DRCTemplate(String rule, int when, DRCRuleType ruleType, double maxW, double minLen, String name1, String name2, double[] vals, int multiCut) {
        this.ruleName = rule;
        this.when = when;
        this.ruleType = ruleType;
        this.name1 = name1;
        this.name2 = name2;
        this.copyValues(vals);
        this.maxWidth = maxW;
        this.minLength = minLen;
        this.multiCuts = multiCut;
        switch (ruleType) {
            case SPACING: {
                if (name1 != null && name2 != null) break;
                System.out.println("Error: missing one layer in no '" + rule + "' ");
                break;
            }
        }
    }

    public static DRCXMLParser importDRCDeck(URL fileURL, boolean verbose) {
        DRCXMLParser parser = new DRCXMLParser();
        parser.process(fileURL, verbose);
        return parser;
    }

    public static void exportDRCDecks(String fileName, Technology tech) {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.println("<!--");
            out.println("\t Document: DRC deck for " + tech);
            out.println("\t Generated by: Electric (" + Version.getVersion() + ")");
            out.println("-->");
            out.println("<!DOCTYPE DRCRules SYSTEM \"DRC.dtd\">");
            out.println("<DRCRules>");
            Iterator<Foundry> it = tech.getFoundries();
            while (it.hasNext()) {
                Foundry foundry = it.next();
                List<DRCTemplate> rules = foundry.getRules();
                out.println("    <Foundry name=\"" + foundry.getType().name() + "\">");
                for (DRCTemplate rule : rules) {
                    if (rule.ruleType == DRCRuleType.EXTENSIONGATE || rule.ruleType == DRCRuleType.CUTSURX || rule.ruleType == DRCRuleType.CUTSURY || rule.ruleType == DRCRuleType.SLOTSIZE) continue;
                    DRCTemplate.exportDRCRule(out, rule);
                }
                out.println("    </Foundry>");
            }
            out.println("</DRCRules>");
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void exportDRCRule(PrintWriter out, DRCTemplate rule) {
        String whenName = null;
        int when = 0;
        for (DRCMode p : DRCMode.values()) {
            if ((p.mode() & ~when) == 0 || (p.mode() & ~rule.when) != 0) continue;
            whenName = whenName == null ? "" : whenName + "|";
            whenName = whenName + (Object)((Object)p);
            when |= p.mode();
        }
        assert (when == rule.when);
        if (whenName == null) {
            whenName = DRCMode.ALL.name();
        }
        switch (rule.ruleType) {
            case MINWID: 
            case MINAREA: 
            case MINENCLOSEDAREA: {
                out.println("        <LayerRule ruleName=\"" + rule.ruleName + "\"" + " layerName=\"" + rule.name1 + "\"" + " type=\"" + (Object)((Object)rule.ruleType) + "\"" + " when=\"" + whenName + "\"" + " value=\"" + rule.getValue(0) + "\"" + "/>");
                break;
            }
            case SPACING: 
            case UCONSPA: 
            case UCONSPA2D: 
            case CONSPA: 
            case SPACINGE: 
            case EXTENSION: 
            case EXTENSIONGATE: {
                String noName = rule.nodeName != null ? " nodeName=\"" + rule.nodeName + "\"" : "";
                String wideValues = rule.maxWidth > 0.0 ? " maxW=\"" + rule.maxWidth + "\"" + " minLen=\"" + rule.minLength + "\"" : "";
                out.println("        <LayersRule ruleName=\"" + rule.ruleName + "\"" + " layerNames=\"{" + rule.name1 + "," + rule.name2 + "}\"" + " type=\"" + (Object)((Object)rule.ruleType) + "\"" + " when=\"" + whenName + "\"" + " value=\"" + rule.getValue(0) + "\"" + wideValues + noName + "/>");
                break;
            }
            case SURROUND: 
            case ASURROUND: {
                String ruleType = "NodeLayersRule";
                String value = " value=\"" + rule.getValue(0) + "\"";
                if (rule.getValue(0) != rule.getValue(1)) {
                    value = " valueX=\"" + rule.getValue(0) + "\"" + " valueY=\"" + rule.getValue(1) + "\"";
                }
                String noName = " nodeName=\"" + rule.nodeName + "\"";
                if (rule.nodeName == null) {
                    noName = "";
                    ruleType = "LayersRule";
                }
                out.println("        <" + ruleType + " ruleName=\"" + rule.ruleName + "\"" + " layerNames=\"{" + rule.name1 + "," + rule.name2 + "}\"" + " type=\"" + (Object)((Object)rule.ruleType) + "\"" + " when=\"" + whenName + "\"" + value + noName + "/>");
                break;
            }
            case NODSIZ: {
                String value = " value=\"" + rule.getValue(0) + "\"";
                if (rule.getValue(0) != rule.getValue(1)) {
                    value = " valueX=\"" + rule.getValue(0) + "\"" + " valueY=\"" + rule.getValue(1) + "\"";
                }
                out.println("        <NodeRule ruleName=\"" + rule.ruleName + "\"" + " type=\"" + (Object)((Object)rule.ruleType) + "\"" + " when=\"" + whenName + "\"" + value + " nodeName=\"" + rule.nodeName + "\"" + "/>");
                break;
            }
            case FORBIDDEN: {
                if (rule.nodeName != null) {
                    out.println("        <NodeRule ruleName=\"" + rule.ruleName + "\"" + " type=\"" + (Object)((Object)rule.ruleType) + "\"" + " when=\"" + whenName + "\"" + " nodeName=\"" + rule.nodeName + "\"" + "/>");
                    break;
                }
                out.println("        <LayersRule ruleName=\"" + rule.ruleName + "\"" + " layerNames=\"{" + rule.name1 + "," + rule.name2 + "}\"" + " type=\"" + (Object)((Object)rule.ruleType) + "\"" + " when=\"" + whenName + "\"" + "/>");
                break;
            }
            default: {
                assert (false);
                System.out.println("Case not implemented " + (Object)((Object)rule.ruleType));
            }
        }
    }

    public static String getSpacingCombinedName(Layer layer, Geometric geo) {
        String n1 = layer.getName() + "-";
        if (geo != null) {
            n1 = geo instanceof NodeInst ? n1 + ((NodeInst)geo).getProto().getName() : n1 + ((ArcInst)geo).getProto().getName();
        }
        return n1;
    }

    public static void parseXmlElement(List<DRCTemplate> drcRules, String qName, Attributes attributes) {
        DRCTemplate tmp;
        boolean layerRule = qName.equals("LayerRule");
        boolean layersRule = qName.equals("LayersRule");
        boolean nodeLayersRule = qName.equals("NodeLayersRule");
        boolean nodeRule = qName.equals("NodeRule");
        if (!(layerRule || layersRule || nodeLayersRule || nodeRule)) {
            return;
        }
        String ruleName = "";
        String layerNames = "";
        String nodeNames = null;
        int when = DRCMode.ALL.mode();
        DRCRuleType type = DRCRuleType.NONE;
        double[] values = new double[2];
        Double maxW = null;
        Double minLen = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (attributes.getQName(i).equals("ruleName")) {
                ruleName = attributes.getValue(i);
                continue;
            }
            if (attributes.getQName(i).startsWith("layerName")) {
                layerNames = attributes.getValue(i);
                continue;
            }
            if (attributes.getQName(i).startsWith("nodeName")) {
                nodeNames = attributes.getValue(i);
                continue;
            }
            if (attributes.getQName(i).equals("type")) {
                type = DRCRuleType.valueOf(attributes.getValue(i));
                continue;
            }
            if (attributes.getQName(i).equals("when")) {
                String[] modes;
                for (String mode : modes = TextUtils.parseString(attributes.getValue(i), "|")) {
                    DRCMode m = DRCMode.valueOf(mode);
                    when |= m.mode();
                }
                continue;
            }
            if (attributes.getQName(i).equals("value")) {
                values[0] = values[1] = Double.parseDouble(attributes.getValue(i));
                continue;
            }
            if (attributes.getQName(i).equals("valueX")) {
                values[0] = Double.parseDouble(attributes.getValue(i));
                continue;
            }
            if (attributes.getQName(i).equals("valueY")) {
                values[1] = Double.parseDouble(attributes.getValue(i));
                continue;
            }
            if (attributes.getQName(i).equals("maxW")) {
                maxW = Double.parseDouble(attributes.getValue(i));
                continue;
            }
            if (attributes.getQName(i).equals("minLen")) {
                minLen = Double.parseDouble(attributes.getValue(i));
                continue;
            }
            new Error("Invalid attribute in DRCXMLParser");
        }
        if (layerRule) {
            String[] layers;
            for (String layer : layers = TextUtils.parseString(layerNames, ",")) {
                String[] names;
                if (nodeNames == null) {
                    tmp = new DRCTemplate(ruleName, when, type, layer, null, values, null);
                    drcRules.add(tmp);
                    continue;
                }
                for (String name : names = TextUtils.parseString(nodeNames, ",")) {
                    DRCTemplate tmp2 = new DRCTemplate(ruleName, when, type, layer, null, values, name);
                    drcRules.add(tmp2);
                }
            }
        } else if (nodeRule) {
            if (nodeNames == null) {
                DRCTemplate tmp3 = new DRCTemplate(ruleName, when, type, null, null, values, null);
                drcRules.add(tmp3);
            } else {
                String[] names;
                for (String name : names = TextUtils.parseString(nodeNames, ",")) {
                    tmp = new DRCTemplate(ruleName, when, type, null, null, values, name);
                    drcRules.add(tmp);
                }
            }
        } else if (layersRule || nodeLayersRule) {
            String[] layerPairs;
            for (String layerPair : layerPairs = TextUtils.parseString(layerNames, "{}")) {
                String[] names;
                String[] pair = TextUtils.parseString(layerPair, ",");
                if (pair.length != 2) continue;
                if (nodeNames == null) {
                    DRCTemplate tmp4 = maxW == null ? new DRCTemplate(ruleName, when, type, pair[0], pair[1], values, null) : new DRCTemplate(ruleName, when, type, maxW, minLen, pair[0], pair[1], values, -1);
                    drcRules.add(tmp4);
                    continue;
                }
                for (String name : names = TextUtils.parseString(nodeNames, ",")) {
                    DRCTemplate tmp5 = null;
                    if (maxW == null) {
                        tmp5 = new DRCTemplate(ruleName, when, type, pair[0], pair[1], values, name);
                    } else {
                        System.out.println("When do I have this case?");
                    }
                    drcRules.add(tmp5);
                }
            }
        } else assert (false);
    }

    public static class DRCXMLParser {
        private List<DRCXMLBucket> rulesList = new ArrayList<DRCXMLBucket>();
        private DRCXMLBucket current = null;
        private boolean fullLoaded = true;
        private String fileName;

        public List<DRCXMLBucket> getRules() {
            return this.rulesList;
        }

        public boolean isParseOK() {
            return this.fullLoaded;
        }

        protected boolean process(URL fileURL, boolean verbose) {
            this.fileName = TextUtils.getFileNameWithoutExtension(fileURL);
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(true);
                SAXParser parser = factory.newSAXParser();
                URLConnection urlCon = fileURL.openConnection();
                InputStream inputStream = urlCon.getInputStream();
                if (verbose) {
                    System.out.println("Parsing XML file \"" + fileURL + "\"");
                }
                DRCXMLHandler handler = new DRCXMLHandler();
                parser.parse(inputStream, (DefaultHandler)handler);
                this.fullLoaded = handler.passed;
                if (verbose) {
                    System.out.println("End Parsing XML file ...");
                }
            }
            catch (Exception e) {
                if (verbose) {
                    e.printStackTrace();
                }
                this.fullLoaded = false;
            }
            return this.fullLoaded;
        }

        private class DRCXMLHandler
        extends DefaultHandler {
            boolean passed = true;

            DRCXMLHandler() {
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
                URL fileURL = this.getClass().getResource("DRC.dtd");
                URLConnection urlCon = fileURL.openConnection();
                InputStream inputStream = urlCon.getInputStream();
                return new InputSource(inputStream);
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                if (qName.equals("DRCRules")) {
                    return;
                }
                if (qName.equals("Foundry")) {
                    DRCXMLParser.this.current = new DRCXMLBucket();
                    DRCXMLParser.this.rulesList.add(DRCXMLParser.this.current);
                    ((DRCXMLParser)DRCXMLParser.this).current.foundry = attributes.getValue(0);
                    return;
                }
                DRCTemplate.parseXmlElement(((DRCXMLParser)DRCXMLParser.this).current.drcRules, qName, attributes);
            }

            @Override
            public void fatalError(SAXParseException e) {
                System.out.println("Parser Fatal Error: '" + e.getMessage() + "' in line " + e.getLineNumber() + " in '" + DRCXMLParser.this.fileName + "'.");
                this.passed = false;
            }

            @Override
            public void warning(SAXParseException e) {
                System.out.println("Parser Warning: '" + e.getMessage() + "' in line " + e.getLineNumber() + " in '" + DRCXMLParser.this.fileName + "'.");
            }

            @Override
            public void error(SAXParseException e) {
                System.out.println("Parser Error: " + e.getMessage() + "' in line " + e.getLineNumber() + " in '" + DRCXMLParser.this.fileName + "'.");
                this.passed = false;
            }
        }
    }

    public static class DRCXMLBucket
    implements Serializable {
        public List<DRCTemplate> drcRules = new ArrayList<DRCTemplate>();
        public String foundry = Foundry.Type.NONE.name();
    }

    public static class DRCTemplateSort
    implements Comparator<DRCTemplate> {
        @Override
        public int compare(DRCTemplate d1, DRCTemplate d2) {
            double bb2;
            double bb1 = d1.getValue(0);
            if (bb1 < (bb2 = d2.getValue(0))) {
                return -1;
            }
            if (bb1 > bb2) {
                return 1;
            }
            return 0;
        }
    }

    public static enum DRCRuleType {
        NONE,
        MINWID,
        NODSIZ,
        SURROUND,
        SPACING,
        SPACINGE,
        CONSPA,
        UCONSPA,
        UCONSPA2D,
        CUTSURX,
        CUTSURY,
        ASURROUND,
        MINAREA,
        MINENCLOSEDAREA,
        EXTENSION,
        FORBIDDEN,
        EXTENSIONGATE,
        SLOTSIZE;

    }

    public static enum DRCMode {
        NONE(-1),
        ALL(0),
        M23(3),
        M2(1),
        M3(2),
        M456(28),
        M4(4),
        M56(24),
        M5(8),
        M6(16),
        M7(32768),
        M8(65536),
        M9(131072),
        AN(262144),
        AC(32),
        NAC(64),
        SV(128),
        NSV(256),
        DE(512),
        SU(1024),
        SC(2048);

        private final int mode;

        private DRCMode(int mode) {
            this.mode = mode;
        }

        public int mode() {
            return this.mode;
        }

        public String toString() {
            return this.name();
        }
    }
}

