/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag.router;

import com.sun.electric.tool.generator.flag.router.Channel;
import com.sun.electric.tool.generator.flag.router.Segment;
import com.sun.electric.tool.generator.layout.LayoutLib;
import java.util.TreeSet;

public class Track {
    private final double center;
    private final int trackNdx;
    private final Channel channel;
    private TreeSet<Segment> segments = new TreeSet();

    public Track(double coord, Channel channel, int trackNdx) {
        this.center = coord;
        this.trackNdx = trackNdx;
        this.channel = channel;
    }

    public boolean isAvailable(double min, double max) {
        for (Segment s : this.segments) {
            if (s.min > max) {
                return true;
            }
            if (s.max < min) continue;
            return false;
        }
        return true;
    }

    private void sanityCheck() {
        Segment prev = null;
        for (Segment s : this.segments) {
            if (prev != null) {
                LayoutLib.error(prev.min >= s.min, "illegally ordered segments");
                LayoutLib.error(prev.max > s.min, "overlapping segments");
            }
            prev = s;
        }
    }

    public Segment allocate(double min, double max) {
        LayoutLib.error(!this.isAvailable(min, max), "overlapping blockages");
        Segment seg = new Segment(min, max, this, this.trackNdx);
        this.segments.add(seg);
        this.sanityCheck();
        return seg;
    }

    public Segment allocateBiggest(double min, double src, double max) {
        Segment prev = null;
        Segment next = null;
        for (Segment s : this.segments) {
            if (s.max <= src) {
                prev = s;
            }
            if (s.min <= src && src <= s.max) {
                return null;
            }
            if (!(src <= s.min)) continue;
            next = s;
            break;
        }
        if (next != null) {
            max = Math.min(max, next.min);
        }
        if (prev != null) {
            min = Math.max(min, prev.max);
        }
        return new Segment(min, max, this, this.trackNdx);
    }

    public boolean isHorizontal() {
        return this.channel.isHorizontal();
    }

    public double getCenter() {
        return this.center;
    }

    public int getIndex() {
        return this.trackNdx;
    }

    public void resort(Segment s) {
        this.segments.remove(s);
        this.segments.add(s);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Track center: " + this.center + "\n");
        if (this.segments.size() != 0) {
            sb.append("      ");
            for (Segment s : this.segments) {
                sb.append(s.toString() + "  ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

