/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.projsettings;

import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.ProjectSettingsFrame;
import com.sun.electric.tool.user.dialogs.projsettings.ProjSettingsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AddedTechnologiesTab
extends ProjSettingsPanel {
    private JPanel addedTechnologies;
    private JList addedTechnologiesList;
    private DefaultListModel addedTechnologiesModel;
    private JScrollPane addedTechnologiesPane;

    public AddedTechnologiesTab(ProjectSettingsFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.addedTechnologies;
    }

    public String getName() {
        return "Added Technologies";
    }

    public void init() {
        this.addedTechnologiesModel = new DefaultListModel();
        this.addedTechnologiesList = new JList(this.addedTechnologiesModel);
        this.addedTechnologiesList.setSelectionMode(0);
        this.addedTechnologiesPane.setViewportView(this.addedTechnologiesList);
        List<String> addedTechnologies = Technology.getSoftTechnologies();
        for (String at : addedTechnologies) {
            this.addedTechnologiesModel.addElement(at);
        }
    }

    public void term() {
        ArrayList<String> addedTechnologies = new ArrayList<String>();
        for (int i = 0; i < this.addedTechnologiesModel.size(); ++i) {
            String at = (String)this.addedTechnologiesModel.get(i);
            addedTechnologies.add(at);
        }
        Technology.setSoftTechnologies(addedTechnologies);
    }

    private void addTechnology() {
        String fileName = OpenFile.chooseInputFile(FileType.XML, null);
        if (fileName == null) {
            return;
        }
        this.addedTechnologiesModel.addElement(fileName);
    }

    private void removeTechnology() {
        int line = this.addedTechnologiesList.getSelectedIndex();
        if (line < 0) {
            return;
        }
        this.addedTechnologiesModel.remove(line);
    }

    private void initComponents() {
        this.addedTechnologies = new JPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AddedTechnologiesTab.this.closeDialog(evt);
            }
        });
        this.addedTechnologies.setLayout(new GridBagLayout());
        JLabel jLabel1 = new JLabel("Technologies that will be added to Electric when it next runs");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.addedTechnologies.add((Component)jLabel1, gridBagConstraints);
        JLabel jLabel2 = new JLabel("(these are XML files created by the Technology Editor)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.addedTechnologies.add((Component)jLabel2, gridBagConstraints);
        this.addedTechnologiesPane = new JScrollPane();
        this.addedTechnologiesPane.setPreferredSize(new Dimension(300, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.addedTechnologies.add((Component)this.addedTechnologiesPane, gridBagConstraints);
        JButton addTech = new JButton("Add");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.addedTechnologies.add((Component)addTech, gridBagConstraints);
        addTech.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddedTechnologiesTab.this.addTechnology();
            }
        });
        JButton removeTech = new JButton("Remove");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.addedTechnologies.add((Component)removeTech, gridBagConstraints);
        removeTech.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddedTechnologiesTab.this.removeTechnology();
            }
        });
        this.getContentPane().add((Component)this.addedTechnologies, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

