/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.tool.io.input.EpicReaderSignal;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;

class EpicReaderProcess {
    private InputStream inputStream;
    private long fileLength;
    private long byteCount;
    private byte[] buf = new byte[65536];
    private int bufL;
    private int bufP;
    private int lineNum;
    private StringBuilder builder = new StringBuilder();
    private Pattern whiteSpace = Pattern.compile("[ \t]+");
    private byte lastProgress;
    private HashMap<String, Integer> stringIds = new HashMap();
    private ArrayList<EpicReaderSignal> signals = new ArrayList();
    private ArrayList<EpicReaderSignal> signalsByEpicIndex = new ArrayList();
    private double timeResolution;
    private double voltageResolution;
    private double currentResolution;
    private int curTime = 0;
    private ArrayList<String> contextStack = new ArrayList();
    private int timesC = 0;
    private int eventsC = 0;
    private DataOutputStream stdOut = new DataOutputStream(System.out);
    private static final String VERSION_STRING = ";! output_format 5.3";
    private static final char separator = '.';

    private EpicReaderProcess() {
    }

    public static void main(String[] args) {
        try {
            EpicReaderProcess process = new EpicReaderProcess();
            try {
                process.readEpic(args[0]);
            }
            catch (IOException e) {
                System.err.println("Failed to read " + args[0]);
                e.printStackTrace(System.err);
                System.exit(1);
            }
            process.writeOut();
        }
        catch (OutOfMemoryError e) {
            System.err.println("Out of memory. Increase memory limit in preferences.");
            e.printStackTrace(System.err);
            System.exit(2);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(3);
        }
    }

    private void readEpic(String urlName) throws IOException {
        URL fileURL = new URL(urlName);
        long startTime = System.currentTimeMillis();
        URLConnection urlCon = fileURL.openConnection();
        urlCon.setConnectTimeout(10000);
        urlCon.setReadTimeout(1000);
        String contentLength = urlCon.getHeaderField("content-length");
        this.fileLength = -1L;
        try {
            this.fileLength = Long.parseLong(contentLength);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.inputStream = urlCon.getInputStream();
        this.byteCount = 0L;
        String firstLine = this.getLine();
        if (firstLine == null || !firstLine.equals(VERSION_STRING)) {
            this.message("Unknown Epic Version: " + firstLine);
        }
        while (this.bufP < this.bufL || !this.readBuf()) {
            int startLine = this.bufP;
            if (this.parseNumLineFast()) continue;
            this.bufP = startLine;
            String line = this.getLine();
            assert (this.bufP <= this.bufL);
            if (line == null) break;
            this.parseNumLine(line);
        }
        this.writeContext("");
        this.inputStream.close();
        long stopTime = System.currentTimeMillis();
        System.err.println((double)(stopTime - startTime) / 1000.0 + " sec to read " + this.byteCount + " bytes " + this.signals.size() + " signals " + this.stringIds.size() + " strings " + this.timesC + " timepoints " + this.eventsC + " events from " + urlName);
    }

    private void parseNumLine(String line) throws IOException {
        if (line.length() == 0) {
            return;
        }
        char ch = line.charAt(0);
        if (ch == '.') {
            String[] split = this.whiteSpace.split(line);
            if (split[0].equals(".index") && split.length == 4) {
                int type;
                if (split[3].equals("v")) {
                    type = 86;
                } else if (split[3].equals("i")) {
                    type = 73;
                } else {
                    this.message("Unknown waveform type: " + line);
                    return;
                }
                String name = split[1];
                int sigNum = this.atoi(split[2]);
                while (this.signalsByEpicIndex.size() <= sigNum) {
                    this.signalsByEpicIndex.add(null);
                }
                EpicReaderSignal s = this.signalsByEpicIndex.get(sigNum);
                if (s == null) {
                    s = new EpicReaderSignal();
                    this.signalsByEpicIndex.set(sigNum, s);
                    this.signals.add(s);
                }
                if (name.startsWith("v(") && name.endsWith(")")) {
                    name = name.substring(2, name.length() - 1);
                } else if (name.startsWith("i(") && name.endsWith(")")) {
                    name = name.substring(2, name.length() - 1);
                } else if (name.startsWith("i1(") && name.endsWith(")")) {
                    name = name.substring(3, name.length() - 1);
                }
                int lastSlashPos = name.lastIndexOf(46);
                String contextName = "";
                if (lastSlashPos > 0) {
                    contextName = name.substring(0, lastSlashPos + 1);
                }
                name = name.substring(lastSlashPos + 1);
                if (type == 73) {
                    name = "i(" + name + ")";
                }
                this.writeContext(contextName);
                this.stdOut.writeByte(type);
                this.writeString(name);
            } else if (!split[0].equals(".vdd") || split.length != 2) {
                if (split[0].equals(".time_resolution") && split.length == 2) {
                    this.timeResolution = this.atof(split[1]) * 1.0E-9;
                } else if (split[0].equals(".current_resolution") && split.length == 2) {
                    this.currentResolution = this.atof(split[1]);
                } else if (split[0].equals(".voltage_resolution") && split.length == 2) {
                    this.voltageResolution = this.atof(split[1]);
                } else if (!(split[0].equals(".high_threshold") && split.length == 2 || split[0].equals(".low_threshold") && split.length == 2 || split[0].equals(".nnodes") && split.length == 2 || split[0].equals(".nelems") && split.length == 2 || split[0].equals(".extra_nodes") && split.length == 2 || split[0].equals(".bus_notation") && split.length == 4 || split[0].equals(".hier_separator") && split.length == 2 || split[0].equals(".case") && split.length == 2)) {
                    this.message("Unrecognized Epic line: " + line);
                }
            }
        } else if (ch >= '0' && ch <= '9') {
            String[] split = this.whiteSpace.split(line);
            int num = this.atoi(split[0]);
            if (split.length > 1) {
                this.putValue(num, this.atoi(split[1]));
            } else {
                this.putTime(num);
            }
        } else if (ch != ';' && !Character.isSpaceChar(ch)) {
            this.message("Unrecognized Epic line: " + line);
        }
    }

    private void writeContext(String s) throws IOException {
        int matchSeps = 0;
        int pos = 0;
        block0: while (matchSeps < this.contextStack.size()) {
            String si = this.contextStack.get(matchSeps);
            if (pos < s.length() && s.charAt(pos) == 'x') {
                ++pos;
            }
            if (pos + si.length() >= s.length() || s.charAt(pos + si.length()) != '.') break;
            for (int k = 0; k < si.length(); ++k) {
                if (s.charAt(pos + k) != si.charAt(k)) break block0;
            }
            ++matchSeps;
            pos += si.length() + 1;
        }
        while (this.contextStack.size() > matchSeps) {
            this.stdOut.writeByte(85);
            this.contextStack.remove(this.contextStack.size() - 1);
        }
        assert (this.contextStack.size() == matchSeps);
        while (pos < s.length()) {
            int indexOfSep = s.indexOf(46, pos);
            assert (indexOfSep >= pos);
            this.stdOut.writeByte(68);
            if (pos < indexOfSep && s.charAt(pos) == 'x') {
                ++pos;
            }
            String si = s.substring(pos, indexOfSep);
            this.writeString(si);
            this.contextStack.add(si);
            pos = indexOfSep + 1;
        }
        assert (pos == s.length());
    }

    private void writeString(String s) throws IOException {
        if (s == null) {
            this.stdOut.writeInt(-1);
            return;
        }
        Integer i = this.stringIds.get(s);
        if (i != null) {
            this.stdOut.writeInt(i);
            return;
        }
        this.stdOut.writeInt(this.stringIds.size());
        i = new Integer(this.stringIds.size());
        s = new String(s);
        this.stringIds.put(s, i);
        this.stdOut.writeUTF(s);
    }

    private boolean parseNumLineFast() {
        byte ch;
        int MAX_DIGITS = 9;
        if (this.bufP + 22 >= this.bufL) {
            return false;
        }
        if ((ch = this.buf[this.bufP++]) < 48 || ch > 57) {
            return false;
        }
        int num1 = ch - 48;
        ch = this.buf[this.bufP++];
        int lim = this.bufP + 8;
        while (48 <= ch && ch <= 57 && this.bufP < lim) {
            num1 = num1 * 10 + (ch - 48);
            ch = this.buf[this.bufP++];
        }
        boolean twoNumbers = false;
        int num2 = 0;
        if (ch == 32) {
            ch = this.buf[this.bufP++];
            boolean sign = false;
            if (ch == 45) {
                sign = true;
                ch = this.buf[this.bufP++];
            }
            if (ch < 48 || ch > 57) {
                return false;
            }
            num2 = ch - 48;
            ch = this.buf[this.bufP++];
            int lim2 = this.bufP + 8;
            while (48 <= ch && ch <= 57 && this.bufP < lim2) {
                num2 = num2 * 10 + (ch - 48);
                ch = this.buf[this.bufP++];
            }
            if (sign) {
                num2 = -num2;
            }
            twoNumbers = true;
        }
        if (ch != 10) {
            if (ch == 13) {
                if (this.buf[this.bufP] == 10) {
                    ++this.bufP;
                }
            } else {
                return false;
            }
        }
        if (twoNumbers) {
            this.putValue(num1, num2);
        } else {
            this.putTime(num1);
        }
        ++this.lineNum;
        return true;
    }

    private void putTime(int time) {
        ++this.timesC;
        this.curTime = Math.max(this.curTime, time);
    }

    private void putValue(int sigNum, int value) {
        EpicReaderSignal s = this.signalsByEpicIndex.get(sigNum);
        if (s == null) {
            this.message("Signal " + sigNum + " not defined");
            return;
        }
        s.putEvent(this.curTime, value);
        ++this.eventsC;
    }

    private String getLine() throws IOException {
        this.builder.setLength(0);
        while (true) {
            if (this.bufP < this.bufL) {
                int ch;
                if ((ch = this.buf[this.bufP++] & 0xFF) == 10) {
                    return this.builder.toString();
                }
                if (ch == 13) {
                    if (this.bufP == this.bufL) {
                        this.readBuf();
                    }
                    if (this.bufP < this.bufL && this.buf[this.bufP] == 10) {
                        ++this.bufP;
                    }
                    return this.builder.toString();
                }
                this.builder.append((char)ch);
                continue;
            }
            if (this.readBuf()) break;
        }
        if (this.builder.length() == 0) {
            return null;
        }
        ++this.lineNum;
        return this.builder.toString();
    }

    private double atof(String s) {
        double value = 0.0;
        try {
            value = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            this.message("Bad float format: " + s);
        }
        return value;
    }

    private int atoi(String s) {
        int value = 0;
        try {
            value = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            this.message("Bad integer format: " + s);
        }
        return value;
    }

    private boolean readBuf() throws IOException {
        assert (this.bufP == this.bufL);
        this.bufL = 0;
        this.bufP = 0;
        this.bufL = this.inputStream.read(this.buf, 0, this.buf.length);
        if (this.bufL <= 0) {
            this.bufL = 0;
            return true;
        }
        this.byteCount += (long)this.bufL;
        this.showProgress(this.fileLength != 0L ? (double)this.byteCount / (double)this.fileLength : 0.0);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOut() throws IOException {
        File tempFile = null;
        FilterOutputStream waveStream = null;
        boolean ok = false;
        try {
            long startTime = System.currentTimeMillis();
            tempFile = File.createTempFile("elec", ".epic");
            waveStream = new BufferedOutputStream(new FileOutputStream(tempFile));
            this.showProgressNote("Writing " + tempFile);
            this.stdOut.writeByte(70);
            this.stdOut.writeDouble(this.timeResolution);
            this.stdOut.writeDouble(this.voltageResolution);
            this.stdOut.writeDouble(this.currentResolution);
            this.stdOut.writeDouble((double)this.curTime * this.timeResolution);
            int size = 0;
            for (EpicReaderSignal s : this.signals) {
                size += s.len;
            }
            int start = 0;
            for (EpicReaderSignal s : this.signals) {
                ((BufferedOutputStream)waveStream).write(s.waveform, 0, s.len);
                this.stdOut.writeInt(s.minV);
                this.stdOut.writeInt(s.maxV);
                this.stdOut.writeInt(s.len);
                this.showProgress(size != 0 ? (double)(start += s.len) / (double)size : 0.0);
            }
            waveStream.close();
            this.stdOut.writeUTF(tempFile.toString());
            this.stdOut.close();
            ok = true;
            long stopTime = System.currentTimeMillis();
            System.err.println((double)(stopTime - startTime) / 1000.0 + " sec to write " + tempFile.length() + " bytes to " + tempFile);
        }
        finally {
            if (ok) {
                return;
            }
            if (waveStream != null) {
                waveStream.close();
            }
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    private void showProgress(double ratio) {
        byte progress = (byte)(ratio * 100.0);
        if (progress == this.lastProgress) {
            return;
        }
        System.err.println("**PROGRESS " + progress);
        this.lastProgress = progress;
    }

    private void showProgressNote(String note) {
        System.err.println("**PROGRESS !" + note);
        this.lastProgress = 0;
    }

    private void message(String s) {
        System.err.println(s + " in line " + (this.lineNum + 1));
    }
}

