/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.Input;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spice
extends Input {
    private Map<String, SubcktDef> allCells = new HashMap<String, SubcktDef>();
    private SpicePreferences localPrefs;
    private String lastLine = null;

    Spice(SpicePreferences ap) {
        this.localPrefs = ap;
    }

    public void readDirectory(URL dirURL, Library lib) {
        try {
            String dirName = dirURL.getPath();
            File dir = new File(dirName);
            if (dir == null) {
                System.out.println("Unable to find files in directory " + dirName);
                return;
            }
            String[] filesInDir = dir.list();
            for (int i = 0; i < filesInDir.length; ++i) {
                URL url;
                String ext;
                String fileName = filesInDir[i];
                int lastDotPos = fileName.lastIndexOf(46);
                if (lastDotPos < 0 || !(ext = fileName.substring(lastDotPos + 1).toLowerCase()).equals("spi") && !ext.equals("sp") || (url = TextUtils.makeURLToFile(dirName + fileName)) == null || this.openTextInput(url)) continue;
                System.out.println("Reading " + fileName);
                this.readSimFile();
                this.closeInput();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.placeCells(lib);
    }

    private void readSimFile() throws IOException {
        String line;
        SubcktDef current = null;
        while ((line = this.getNextLine()) != null) {
            int i;
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '*') continue;
            String lineLC = line.toLowerCase();
            if (lineLC.startsWith(".subckt")) {
                String[] expPieces = line.split(" ");
                current = new SubcktDef();
                this.allCells.put(expPieces[1], current);
                for (int i2 = 2; i2 < expPieces.length; ++i2) {
                    current.exports.add(expPieces[i2]);
                }
                continue;
            }
            if (lineLC.startsWith(".ends")) {
                current = null;
            }
            if (lineLC.charAt(0) == 'm' && current != null) {
                TransistorDef td = new TransistorDef();
                current.transistors.add(td);
                String[] traPieces = line.split(" ");
                if (traPieces.length < 6) {
                    System.out.println("Error on Transistor line: " + line);
                    continue;
                }
                td.name = traPieces[0].substring(1);
                td.drain = traPieces[1];
                td.gate = traPieces[2];
                td.source = traPieces[3];
                td.bias = traPieces[4];
                td.type = traPieces[5].toLowerCase();
                for (i = 6; i < traPieces.length; ++i) {
                    if (traPieces[i].toLowerCase().startsWith("w=")) {
                        td.width = traPieces[i];
                    }
                    if (!traPieces[i].toLowerCase().startsWith("l=")) continue;
                    td.length = traPieces[i];
                }
                continue;
            }
            if (lineLC.charAt(0) == 'r' && current != null) {
                ResistorDef rd = new ResistorDef();
                current.resistors.add(rd);
                String[] resPieces = line.split(" ");
                if (resPieces.length < 3) {
                    System.out.println("Error on Resistor line: " + line);
                    continue;
                }
                rd.name = resPieces[0].substring(1);
                rd.left = resPieces[1];
                rd.right = resPieces[2];
                if (resPieces.length < 4) continue;
                rd.resistance = resPieces[3];
                continue;
            }
            if (lineLC.charAt(0) == 'c' && current != null) {
                CapacitorDef cd = new CapacitorDef();
                current.capacitors.add(cd);
                String[] capPieces = line.split(" ");
                if (capPieces.length < 3) {
                    System.out.println("Error on Capacitor line: " + line);
                    continue;
                }
                cd.name = capPieces[0].substring(1);
                cd.top = capPieces[1];
                cd.bottom = capPieces[2];
                if (capPieces.length < 4) continue;
                cd.capacitance = capPieces[3];
                continue;
            }
            if (lineLC.charAt(0) != 'x' || current == null) continue;
            InstanceDef id = new InstanceDef();
            current.instances.add(id);
            String[] iPieces = line.split(" ");
            if (iPieces.length < 2) {
                System.out.println("Error on Instance line: " + line);
                continue;
            }
            id.name = iPieces[0].substring(1);
            id.instName = iPieces[iPieces.length - 1];
            for (i = 1; i < iPieces.length - 1; ++i) {
                id.signals.add(iPieces[i]);
            }
        }
    }

    private void placeCells(Library lib) {
        NodeInst ni;
        Comparable<PrimitiveNode> np;
        Cell cell;
        SubcktDef sd;
        for (String name : this.allCells.keySet()) {
            double yPos;
            sd = this.allCells.get(name);
            sd.iconCell = cell = Cell.makeInstance(lib, name + "{ic}");
            double lowY = yPos = 1.0;
            for (String export : sd.exports) {
                PrimitiveNode np2 = Schematics.tech().wirePinNode;
                EPoint center1 = new EPoint(0.0, yPos);
                EPoint center2 = new EPoint(2.0, yPos);
                NodeInst ni1 = NodeInst.makeInstance(np2, center1, np2.getDefWidth(), np2.getDefHeight(), cell);
                PortInst pi1 = ni1.getOnlyPortInst();
                NodeInst ni2 = NodeInst.makeInstance(np2, center2, np2.getDefWidth(), np2.getDefHeight(), cell);
                PortInst pi2 = ni2.getOnlyPortInst();
                ArcProto ap = Schematics.tech().wire_arc;
                ArcInst.makeInstance(ap, pi1, pi2);
                Export e = Export.newInstance(cell, pi1, export, PortCharacteristic.UNKNOWN);
                TextDescriptor newTD = e.getTextDescriptor(Export.EXPORT_NAME).withPos(AbstractTextDescriptor.Position.LEFT);
                e.setTextDescriptor(Export.EXPORT_NAME, newTD);
                yPos += 2.0;
            }
            if (yPos == lowY) {
                yPos += 2.0;
            }
            double width = 10.0;
            double height = yPos - lowY;
            EPoint center = new EPoint(7.0, (yPos - 2.0 + lowY) / 2.0);
            np = Artwork.tech().boxNode;
            ni = NodeInst.makeInstance((NodeProto)((Object)np), center, width, height, cell);
            ni.setName(name);
            TextDescriptor newTD = ni.getTextDescriptor(NodeInst.NODE_NAME).withRelSize(2.0);
            ni.setTextDescriptor(NodeInst.NODE_NAME, newTD);
        }
        for (String name : this.allCells.keySet()) {
            PortInst piGate;
            PortInst piSource;
            NodeInst ni2;
            PrimitiveNode np3;
            sd = this.allCells.get(name);
            cell = Cell.makeInstance(lib, name + "{sch}");
            if (sd.iconCell != null) {
                EPoint center = new EPoint(0.0, 15.0);
                NodeInst.makeInstance(sd.iconCell, center, sd.iconCell.getDefWidth(), sd.iconCell.getDefHeight(), cell);
            }
            double pPos = 0.0;
            double nPos = 0.0;
            for (TransistorDef td : sd.transistors) {
                TextDescriptor newTD;
                Variable var;
                EPoint center = null;
                PrimitiveNode.Function func = null;
                if (td.type.equals("p")) {
                    center = new EPoint(pPos, 5.0);
                    pPos += 10.0;
                    func = PrimitiveNode.Function.TRAPMOS;
                } else {
                    center = new EPoint(nPos, -5.0);
                    nPos += 10.0;
                    func = PrimitiveNode.Function.TRANMOS;
                }
                PrimitiveNode np4 = Schematics.tech().transistorNode;
                Orientation o = Orientation.R;
                ni = NodeInst.makeInstance((NodeProto)np4, (Point2D)center, np4.getDefWidth(), np4.getDefHeight(), cell, o, "m" + td.name, func);
                TextDescriptor tdesc = TextDescriptor.newTextDescriptor(MutableTextDescriptor.getNodeTextDescriptor());
                AbstractTextDescriptor.Rotation r = AbstractTextDescriptor.Rotation.getRotation(270);
                ni.setTextDescriptor(NodeInst.NODE_NAME, tdesc.withRotation(r).withPos(AbstractTextDescriptor.Position.DOWNLEFT));
                if (td.width != null) {
                    var = ni.newDisplayVar(Schematics.ATTR_WIDTH, td.width);
                    newTD = var.getTextDescriptor().withRotation(r).withOff(0.5, -0.5).withRelSize(1.0).withPos(AbstractTextDescriptor.Position.DOWN);
                    ni.setTextDescriptor(Schematics.ATTR_WIDTH, newTD);
                }
                if (td.length != null) {
                    var = ni.newDisplayVar(Schematics.ATTR_LENGTH, td.length);
                    newTD = var.getTextDescriptor().withRotation(r).withOff(-0.5, -0.75).withRelSize(0.5).withPos(AbstractTextDescriptor.Position.DOWN);
                    ni.setTextDescriptor(Schematics.ATTR_LENGTH, newTD);
                }
                PortInst piSource2 = ni.getTransistorSourcePort();
                this.addLead(piSource2, 0.0, -2.0, cell, td.source, sd.exports, sd.usedExports);
                PortInst piGate2 = ni.getTransistorGatePort();
                this.addLead(piGate2, -2.0, 0.0, cell, td.gate, sd.exports, sd.usedExports);
                PortInst piDrain = ni.getTransistorDrainPort();
                this.addLead(piDrain, 0.0, 2.0, cell, td.drain, sd.exports, sd.usedExports);
            }
            for (ResistorDef rd : sd.resistors) {
                EPoint center = new EPoint(pPos, 5.0);
                pPos += 10.0;
                np3 = Schematics.tech().resistorNode;
                ni2 = NodeInst.makeInstance(np3, center, np3.getDefWidth(), np3.getDefHeight(), cell, Orientation.IDENT, "r" + rd.name);
                if (rd.resistance != null) {
                    Variable var = ni2.newDisplayVar(Schematics.SCHEM_RESISTANCE, rd.resistance);
                    TextDescriptor newTD = var.getTextDescriptor().withOff(0.0, 0.5).withPos(AbstractTextDescriptor.Position.UP);
                    ni2.setTextDescriptor(Schematics.SCHEM_RESISTANCE, newTD);
                }
                piSource = ni2.getPortInst(0);
                this.addLead(piSource, -2.0, 0.0, cell, rd.left, sd.exports, sd.usedExports);
                piGate = ni2.getPortInst(1);
                this.addLead(piGate, 2.0, 0.0, cell, rd.right, sd.exports, sd.usedExports);
            }
            for (CapacitorDef cd : sd.capacitors) {
                EPoint center = new EPoint(nPos, -5.0);
                nPos += 10.0;
                np3 = Schematics.tech().capacitorNode;
                ni2 = NodeInst.makeInstance(np3, center, np3.getDefWidth(), np3.getDefHeight(), cell, Orientation.IDENT, "c" + cd.name);
                if (cd.capacitance != null) {
                    ni2.newDisplayVar(Schematics.SCHEM_CAPACITANCE, cd.capacitance);
                }
                piSource = ni2.getPortInst(0);
                this.addLead(piSource, 0.0, 2.0, cell, cd.top, sd.exports, sd.usedExports);
                piGate = ni2.getPortInst(1);
                this.addLead(piGate, 0.0, -2.0, cell, cd.bottom, sd.exports, sd.usedExports);
            }
            double iPos = 0.0;
            for (InstanceDef id : sd.instances) {
                SubcktDef subSD = this.allCells.get(id.instName);
                if (subSD == null) {
                    System.out.println("Cannot find subcircuit " + id.instName);
                    continue;
                }
                np = subSD.iconCell;
                EPoint center = new EPoint(iPos, -10.0 - ((Cell)np).getDefHeight());
                iPos += 30.0;
                NodeInst ni3 = NodeInst.makeInstance(np, center, ((Cell)np).getDefWidth(), ((Cell)np).getDefHeight(), cell);
                ni3.setName(id.name.replace('@', '_'));
                TextDescriptor newTD = ni3.getTextDescriptor(NodeInst.NODE_NAME).withOff(1.0, -1.0).withPos(AbstractTextDescriptor.Position.DOWN);
                ni3.setTextDescriptor(NodeInst.NODE_NAME, newTD);
                if (subSD.exports.size() != id.signals.size()) {
                    System.out.println("Error: Subcircuit " + id.instName + " has " + subSD.exports.size() + " exports but instance " + id.name + " of it in cell " + cell.describe(false) + " has " + id.signals.size() + " signals on it");
                    continue;
                }
                for (int i = 0; i < subSD.exports.size(); ++i) {
                    PortProto pp = subSD.iconCell.findPortProto(subSD.exports.get(i));
                    if (pp == null) continue;
                    PortInst pi = ni3.findPortInstFromProto(pp);
                    String sigName = id.signals.get(i);
                    this.addLead(pi, -2.0, 0.0, cell, sigName, sd.exports, sd.usedExports);
                }
            }
            double dummyPos = 30.0;
            for (String export : sd.exports) {
                if (sd.usedExports.contains(export)) continue;
                EPoint ctr = new EPoint(dummyPos, 15.0);
                dummyPos += 10.0;
                PrimitiveNode np5 = Schematics.tech().wirePinNode;
                NodeInst ni4 = NodeInst.makeInstance(np5, ctr, np5.getDefWidth(), np5.getDefHeight(), cell);
                Export.newInstance(cell, ni4.getOnlyPortInst(), export, PortCharacteristic.UNKNOWN);
            }
        }
    }

    private void addLead(PortInst pi, double dX, double dY, Cell cell, String name, List<String> exports, Set<String> usedExports) {
        EPoint ctr1 = pi.getCenter();
        EPoint ctr2 = new EPoint(ctr1.getX() + dX, ctr1.getY() + dY);
        PrimitiveNode np = Schematics.tech().wirePinNode;
        NodeInst ni = NodeInst.makeInstance(np, ctr2, np.getDefWidth(), np.getDefHeight(), cell);
        ArcProto ap = Schematics.tech().wire_arc;
        PortInst pi2 = ni.getOnlyPortInst();
        ArcInst ai = ArcInst.makeInstance(ap, pi, pi2);
        if (exports.contains(name = name.replace('@', '_')) && !usedExports.contains(name)) {
            usedExports.add(name);
            Export.newInstance(cell, pi2, name, PortCharacteristic.UNKNOWN);
        } else {
            ai.setName(name);
            AbstractTextDescriptor.Position p = dX == 0.0 ? AbstractTextDescriptor.Position.LEFT : AbstractTextDescriptor.Position.DOWN;
            TextDescriptor newTD = ai.getTextDescriptor(ArcInst.ARC_NAME).withPos(p);
            ai.setTextDescriptor(ArcInst.ARC_NAME, newTD);
        }
    }

    private String getNextLine() throws IOException {
        String line = this.lastLine;
        if (line == null) {
            line = this.getLine();
        }
        if (line != null) {
            this.lastLine = this.getLine();
            while (this.lastLine != null && this.lastLine.startsWith("+")) {
                line = line + this.lastLine.substring(1);
                this.lastLine = this.getLine();
            }
        }
        return line;
    }

    private static class CapacitorDef {
        String name;
        String top;
        String bottom;
        String capacitance;

        private CapacitorDef() {
        }
    }

    private static class ResistorDef {
        String name;
        String left;
        String right;
        String resistance;

        private ResistorDef() {
        }
    }

    private static class TransistorDef {
        String name;
        String source;
        String gate;
        String drain;
        String bias;
        String type;
        String width;
        String length;

        private TransistorDef() {
        }
    }

    private static class InstanceDef {
        String name;
        String instName;
        List<String> signals = new ArrayList<String>();
    }

    private static class SubcktDef {
        List<String> exports = new ArrayList<String>();
        List<TransistorDef> transistors = new ArrayList<TransistorDef>();
        List<ResistorDef> resistors = new ArrayList<ResistorDef>();
        List<CapacitorDef> capacitors = new ArrayList<CapacitorDef>();
        List<InstanceDef> instances = new ArrayList<InstanceDef>();
        Set<String> usedExports = new HashSet<String>();
        Cell iconCell;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SpicePreferences
    extends Input.InputPreferences {
        public SpicePreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, Map<Library, Cell> currentCells, Job job) {
            Spice in = new Spice(this);
            in.readDirectory(fileURL, lib);
            return lib;
        }
    }
}

