/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.result.equivalence;

import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.result.equivalence.NccContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InstancePathToNccContext
implements Serializable {
    static final long serialVersionUID = 0L;
    private NccContext root;
    private Map<VarContext, NccContext> varToNccContext = new HashMap<VarContext, NccContext>();

    private NccContext getNccContext(VarContext vc) {
        NccContext nc = this.varToNccContext.get(vc);
        if (nc == null) {
            nc = new NccContext(vc);
            this.varToNccContext.put(vc, nc);
            if (vc == VarContext.globalContext) {
                this.root = nc;
            } else {
                NccContext parent = this.getNccContext(vc.pop());
                parent.addChild(nc);
            }
        }
        return nc;
    }

    private void addNameProxyIndex(HierarchyEnumerator.NameProxy np, int i) {
        NccContext nc = this.getNccContext(np.getContext());
        nc.addNameProxyIndex(np, i);
    }

    private List<String> instNames(VarContext vc) {
        if (vc == VarContext.globalContext) {
            return new ArrayList<String>();
        }
        List<String> names = this.instNames(vc.pop());
        names.add(vc.getNodable().getName());
        return names;
    }

    public InstancePathToNccContext(HierarchyEnumerator.NameProxy[] objects) {
        int numObj = objects.length;
        for (int i = 0; i < numObj; ++i) {
            this.addNameProxyIndex(objects[i], i);
        }
    }

    public NccContext findNccContext(VarContext vc) {
        if (this.root == null) {
            return null;
        }
        List<String> names = this.instNames(vc);
        NccContext nc = this.root;
        for (String instNm : names) {
            if ((nc = nc.findChild(instNm)) != null) continue;
            return null;
        }
        return nc;
    }
}

