/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem;

import gnu.gleem.linalg.IntersectionPoint;
import gnu.gleem.linalg.Vec3f;

public class BSphere {
    private Vec3f center = new Vec3f();
    private float radius;
    private float radSq;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$gnu$gleem$BSphere;

    public BSphere() {
        this.makeEmpty();
    }

    public BSphere(Vec3f center, float radius) {
        this.set(center, radius);
    }

    public void makeEmpty() {
        this.center.set(0.0f, 0.0f, 0.0f);
        this.radSq = 0.0f;
        this.radius = 0.0f;
    }

    public void setCenter(Vec3f center) {
        this.center.set(center);
    }

    public Vec3f getCenter() {
        return this.center;
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.radSq = radius * radius;
    }

    public float getRadius() {
        return this.radius;
    }

    public void set(Vec3f center, float radius) {
        this.setCenter(center);
        this.setRadius(radius);
    }

    float get(Vec3f center) {
        center.set(this.center);
        return this.radius;
    }

    public void extendBy(BSphere arg) {
        if (this.radius == 0.0f || arg.radius == 0.0f) {
            return;
        }
        Vec3f diff = arg.center.minus(this.center);
        if (diff.lengthSquared() == 0.0f) {
            this.setRadius(Math.max(this.radius, arg.radius));
            return;
        }
        IntersectionPoint[] intPt = new IntersectionPoint[4];
        int i = 0;
        while (i < intPt.length) {
            intPt[i] = new IntersectionPoint();
            ++i;
        }
        int numIntersections = this.intersectRay(this.center, diff, intPt[0], intPt[1]);
        if (!$assertionsDisabled && numIntersections != 2) {
            throw new AssertionError();
        }
        numIntersections = this.intersectRay(this.center, diff, intPt[2], intPt[3]);
        if (!$assertionsDisabled && numIntersections != 2) {
            throw new AssertionError();
        }
        IntersectionPoint minIntPt = intPt[0];
        IntersectionPoint maxIntPt = intPt[0];
        int i2 = 0;
        while (i2 < 4) {
            if (intPt[i2].getT() < minIntPt.getT()) {
                minIntPt = intPt[i2];
            } else if (intPt[i2].getT() > maxIntPt.getT()) {
                maxIntPt = intPt[i2];
            }
            ++i2;
        }
        this.center.add(minIntPt.getIntersectionPoint(), maxIntPt.getIntersectionPoint());
        this.center.scale(0.5f);
        this.setRadius(0.5f * minIntPt.getIntersectionPoint().minus(maxIntPt.getIntersectionPoint()).length());
    }

    int intersectRay(Vec3f rayStart, Vec3f rayDirection, IntersectionPoint intPt0, IntersectionPoint intPt1) {
        Vec3f tempDiff;
        float c;
        float a = rayDirection.lengthSquared();
        if ((double)a == 0.0) {
            return 0;
        }
        float b = 2.0f * (rayStart.dot(rayDirection) - rayDirection.dot(this.center));
        float disc = b * b - 4.0f * a * (c = (tempDiff = this.center.minus(rayStart)).lengthSquared() - this.radSq);
        if (disc < 0.0f) {
            return 0;
        }
        int numIntersections = disc == 0.0f ? 1 : 2;
        intPt0.setT(0.5f * (-1.0f * b + (float)Math.sqrt(disc)) / a);
        if (numIntersections == 2) {
            intPt1.setT(0.5f * (-1.0f * b - (float)Math.sqrt(disc)) / a);
        }
        Vec3f tmp = new Vec3f(rayDirection);
        tmp.scale(intPt0.getT());
        tmp.add(tmp, rayStart);
        intPt0.setIntersectionPoint(tmp);
        if (numIntersections == 2) {
            tmp.set(rayDirection);
            tmp.scale(intPt1.getT());
            tmp.add(tmp, rayStart);
            intPt1.setIntersectionPoint(tmp);
        }
        return numIntersections;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$gnu$gleem$BSphere == null ? (class$gnu$gleem$BSphere = BSphere.class$("gnu.gleem.BSphere")) : class$gnu$gleem$BSphere).desiredAssertionStatus();
    }
}

