/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem;

import gl4java.GLFunc;
import gl4java.GLRunnable;
import gl4java.GLUFunc;
import gl4java.drawable.GLDrawable;
import gl4java.drawable.GLEventListener;
import gnu.gleem.BSphere;
import gnu.gleem.BSphereProvider;
import gnu.gleem.CameraParameters;
import gnu.gleem.ManipManager;
import gnu.gleem.linalg.Rotf;
import gnu.gleem.linalg.Vec3f;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;

public class ExaminerViewer {
    private GLDrawable window;
    private boolean interactionUnderway;
    private boolean iOwnInteraction;
    private boolean button1Down;
    private boolean button2Down;
    private int numMouseButtons;
    private int lastX;
    private int lastY;
    Vec3f position;
    Rotf orientation;
    float focalDist;
    float minFocalDist;
    float rotateSpeed;
    float minRotateSpeed;
    float dollySpeed;
    float minDollySpeed;
    CameraParameters params;
    BSphereProvider provider;
    private MouseMotionAdapter mouseMotionListener = new MouseMotionAdapter(){

        public void mouseDragged(MouseEvent e) {
            ExaminerViewer.this.motionMethod(e, e.getX(), e.getY());
        }

        public void mouseMoved(MouseEvent e) {
            ExaminerViewer.this.passiveMotionMethod(e);
        }
    };
    private MouseAdapter mouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            ExaminerViewer.this.mouseMethod(e, e.getModifiers(), true, e.getX(), e.getY());
        }

        public void mouseReleased(MouseEvent e) {
            ExaminerViewer.this.mouseMethod(e, e.getModifiers(), false, e.getX(), e.getY());
        }
    };
    private GLEventListener glListener = new GLEventListener(){

        public void init(GLDrawable drawable) {
        }

        public void preDisplay(GLDrawable drawable) {
        }

        public void display(GLDrawable drawable) {
        }

        public void postDisplay(GLDrawable drawable) {
        }

        public void cleanup(GLDrawable drawable) {
            ExaminerViewer.this.detach();
        }

        public void reshape(GLDrawable drawable, int width, int height) {
            ExaminerViewer.this.reshapeMethod(width, height);
        }
    };
    private static final float EPSILON = 1.0E-4f;

    public ExaminerViewer(int numMouseButtons) {
        this.numMouseButtons = numMouseButtons;
        this.focalDist = 10.0f;
        this.minFocalDist = 1.0f;
        this.rotateSpeed = 4.0f;
        this.minRotateSpeed = 1.0E-4f;
        this.dollySpeed = 2.0f;
        this.minDollySpeed = 1.0E-4f;
        this.position = new Vec3f();
        this.orientation = new Rotf();
        this.params = new CameraParameters();
    }

    public void attach(GLDrawable window, BSphereProvider provider) {
        this.window = window;
        this.provider = provider;
        this.init();
        this.setupListeners();
    }

    public void detach() {
        this.removeListeners();
        this.window = null;
        this.provider = null;
    }

    public void update(GLFunc gl, GLUFunc glu) {
        this.recalc(gl, glu);
    }

    public void viewAll(GLFunc gl, GLUFunc glu) {
        float horizFOV;
        if (this.provider == null) {
            return;
        }
        float vertFOV = 2.0f * this.params.getVertFOV();
        float minFOV = vertFOV < (horizFOV = 2.0f * (float)Math.atan((double)this.params.getImagePlaneAspectRatio() * Math.tan(this.params.getVertFOV()))) ? vertFOV : horizFOV;
        if (minFOV == 0.0f) {
            throw new RuntimeException("Minimum field of view was zero");
        }
        BSphere bsph = this.provider.getBoundingSphere();
        float dist = bsph.getRadius() / (float)Math.sin(minFOV / 2.0f);
        Vec3f dir = this.orientation.rotateVector(Vec3f.Z_AXIS);
        dir.scale(dist / dir.length());
        this.position.add(dir, bsph.getCenter());
        this.focalDist = dist;
        this.recalc(gl, glu);
    }

    public CameraParameters getCameraParameters() {
        return this.params;
    }

    public void rotateFaster() {
        this.rotateSpeed *= 2.0f;
    }

    public void rotateSlower() {
        if (this.rotateSpeed < this.minRotateSpeed) {
            return;
        }
        this.rotateSpeed /= 2.0f;
    }

    public void dollyFaster() {
        this.dollySpeed *= 2.0f;
    }

    public void dollySlower() {
        if (this.dollySpeed < this.minDollySpeed) {
            return;
        }
        this.dollySpeed /= 2.0f;
    }

    private void setupListeners() {
        ManipManager.getManipManager().removeMouseListeners(this.window);
        this.window.addMouseMotionListener((MouseMotionListener)this.mouseMotionListener);
        this.window.addMouseListener((MouseListener)this.mouseListener);
        this.window.addGLEventListener(this.glListener);
    }

    private void removeListeners() {
        this.window.removeMouseMotionListener((MouseMotionListener)this.mouseMotionListener);
        this.window.removeMouseListener((MouseListener)this.mouseListener);
        this.window.removeGLEventListener(this.glListener);
        ManipManager.getManipManager().setupMouseListeners(this.window);
    }

    private void passiveMotionMethod(MouseEvent e) {
        ManipManager.getManipManager().mouseMoved(e);
    }

    private static boolean modifiersMatch(MouseEvent e) {
        return (e.isAltDown() || e.isMetaDown()) && !e.isControlDown() && !e.isShiftDown();
    }

    private void init() {
        this.focalDist = 10.0f;
        this.minFocalDist = 1.0f;
        this.rotateSpeed = 4.0f;
        this.minRotateSpeed = 1.0E-4f;
        this.dollySpeed = 2.0f;
        this.minDollySpeed = 1.0E-4f;
        this.interactionUnderway = false;
        this.iOwnInteraction = false;
        this.button1Down = false;
        this.button2Down = false;
        this.provider = null;
        this.position.set(0.0f, 0.0f, 0.0f);
        Dimension size = this.window.getSize();
        int xSize = size.width;
        int ySize = size.height;
        this.params.setPosition(this.position);
        this.params.setForwardDirection(Vec3f.NEG_Z_AXIS);
        this.params.setUpDirection(Vec3f.Y_AXIS);
        this.params.setVertFOV(0.3926991f);
        this.params.setImagePlaneAspectRatio((float)xSize / (float)ySize);
        this.params.setXSize(xSize);
        this.params.setYSize(ySize);
    }

    private void motionMethod(MouseEvent e, int x, int y) {
        if (this.interactionUnderway && !this.iOwnInteraction) {
            ManipManager.getManipManager().mouseDragged(e);
        } else {
            int dx = x - this.lastX;
            int dy = y - this.lastY;
            this.lastX = x;
            this.lastY = y;
            if (this.button1Down && !this.button2Down) {
                float xRads = (float)(-Math.PI) * (float)dy * this.rotateSpeed / 1000.0f;
                float yRads = (float)(-Math.PI) * (float)dx * this.rotateSpeed / 1000.0f;
                Vec3f fw = new Vec3f(0.0f, 0.0f, -1.0f);
                Vec3f diff = new Vec3f(this.orientation.rotateVector(fw));
                diff.normalize();
                diff.scale(this.focalDist);
                Rotf xRot = new Rotf(Vec3f.X_AXIS, xRads);
                Rotf yRot = new Rotf(Vec3f.Y_AXIS, yRads);
                Rotf newRot = yRot.times(xRot);
                this.orientation = this.orientation.times(newRot);
                Vec3f backOut = this.orientation.rotateVector(fw);
                backOut.normalize();
                backOut.scale(-1.0f * this.focalDist);
                this.position = this.position.plus(backOut).plus(diff);
            } else if (this.button2Down && !this.button1Down) {
                Vec3f localDiff = new Vec3f(this.dollySpeed * -1.0f * (float)dx / 100.0f, this.dollySpeed * (float)dy / 100.0f, 0.0f);
                Vec3f worldDiff = this.orientation.rotateVector(localDiff);
                this.position.add(worldDiff);
            } else if (this.button1Down && this.button2Down) {
                Vec3f localDiff = new Vec3f(0.0f, 0.0f, this.dollySpeed * -1.0f * (float)dy / 100.0f);
                Vec3f worldDiff = this.orientation.rotateVector(localDiff);
                this.position.add(worldDiff);
                float focalDiff = worldDiff.length();
                if (dy > 0) {
                    focalDiff *= -1.0f;
                }
                this.focalDist += focalDiff;
                if (this.focalDist < this.minFocalDist) {
                    this.focalDist = this.minFocalDist;
                }
            }
            if (!(this.window instanceof GLRunnable)) {
                this.window.repaint();
            }
        }
    }

    private void mouseMethod(MouseEvent e, int mods, boolean press, int x, int y) {
        if (this.interactionUnderway && !this.iOwnInteraction || !ExaminerViewer.modifiersMatch(e)) {
            if (press) {
                this.interactionUnderway = true;
                this.iOwnInteraction = false;
                ManipManager.getManipManager().mousePressed(e);
            } else {
                this.interactionUnderway = false;
                this.iOwnInteraction = false;
                ManipManager.getManipManager().mouseReleased(e);
            }
        } else {
            if ((mods & 0x10) != 0) {
                this.button1Down = press;
            } else if (this.numMouseButtons == 2) {
                if ((mods & 8) != 0) {
                    this.button2Down = press;
                }
            } else if (this.numMouseButtons == 3 && (mods & 4) != 0) {
                this.button2Down = press;
            }
            this.lastX = x;
            this.lastY = y;
            if (this.button1Down || this.button2Down) {
                this.interactionUnderway = true;
                this.iOwnInteraction = true;
            } else {
                this.interactionUnderway = false;
                this.iOwnInteraction = false;
            }
            if (!(this.window instanceof GLRunnable)) {
                this.window.repaint();
            }
        }
    }

    private void reshapeMethod(int w, int h) {
        float aspect = (float)w / (float)h;
        float theta = w >= h ? 45.0f : (float)Math.toDegrees(Math.atan(1.0f / aspect));
        this.params.setVertFOV((float)(Math.toRadians(theta) / 2.0));
        this.params.setImagePlaneAspectRatio(aspect);
        this.params.setXSize(w);
        this.params.setYSize(h);
    }

    private void recalc(GLFunc gl, GLUFunc glu) {
        this.params.setPosition(this.position);
        Vec3f tmp = new Vec3f();
        this.orientation.rotateVector(Vec3f.NEG_Z_AXIS, tmp);
        this.params.setForwardDirection(tmp);
        this.orientation.rotateVector(Vec3f.Y_AXIS, tmp);
        this.params.setUpDirection(tmp);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        float ang = this.orientation.get(tmp);
        if (tmp.lengthSquared() > 1.0E-4f) {
            gl.glRotatef((float)Math.toDegrees(ang), -tmp.x(), -tmp.y(), -tmp.z());
        }
        gl.glTranslatef(-this.position.x(), -this.position.y(), -this.position.z());
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        glu.gluPerspective(Math.toDegrees((double)this.params.getVertFOV() * 2.0), (double)this.params.getImagePlaneAspectRatio(), 1.0, 100.0);
    }

    static {
        EPSILON = 1.0E-4f;
    }
}

