/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem.linalg;

import gnu.gleem.linalg.DimensionMismatchException;
import gnu.gleem.linalg.Mat2f;
import gnu.gleem.linalg.Mat3f;
import gnu.gleem.linalg.Mat4f;
import gnu.gleem.linalg.Vecf;

public class Matf {
    private float[] data;
    private int nCol;
    private int nRow;

    public Matf(int nRow, int nCol) {
        this.data = new float[nRow * nCol];
        this.nCol = nCol;
        this.nRow = nRow;
    }

    public Matf(Matf arg) {
        this.nRow = arg.nRow;
        this.nCol = arg.nCol;
        this.data = new float[this.nRow * this.nCol];
        System.arraycopy(arg.data, 0, this.data, 0, this.data.length);
    }

    public int nRow() {
        return this.nRow;
    }

    public int nCol() {
        return this.nCol;
    }

    public float get(int i, int j) {
        return this.data[this.nCol * i + j];
    }

    public void set(int i, int j, float val) {
        this.data[this.nCol * i + j] = val;
    }

    public Matf transpose() {
        Matf tmp = new Matf(this.nCol, this.nRow);
        int i = 0;
        while (i < this.nRow) {
            int j = 0;
            while (j < this.nCol) {
                tmp.set(j, i, this.get(i, j));
                ++j;
            }
            ++i;
        }
        return tmp;
    }

    public Matf mul(Matf b) throws DimensionMismatchException {
        if (this.nCol() != b.nRow()) {
            throw new DimensionMismatchException();
        }
        Matf tmp = new Matf(this.nRow(), b.nCol());
        int i = 0;
        while (i < this.nRow()) {
            int j = 0;
            while (j < b.nCol()) {
                float val = 0.0f;
                int t = 0;
                while (t < this.nCol()) {
                    val += this.get(i, t) * b.get(t, j);
                    ++t;
                }
                tmp.set(i, j, val);
                ++j;
            }
            ++i;
        }
        return tmp;
    }

    public Vecf mul(Vecf v) throws DimensionMismatchException {
        if (this.nCol() != v.length()) {
            throw new DimensionMismatchException();
        }
        Vecf out = new Vecf(this.nRow());
        int i = 0;
        while (i < this.nRow()) {
            float tmp = 0.0f;
            int j = 0;
            while (j < this.nCol()) {
                tmp += this.get(i, j) * v.get(j);
                ++j;
            }
            out.set(i, tmp);
            ++i;
        }
        return out;
    }

    public Mat2f toMat2f() throws DimensionMismatchException {
        if (this.nRow() != 2 || this.nCol() != 2) {
            throw new DimensionMismatchException();
        }
        Mat2f tmp = new Mat2f();
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                tmp.set(i, j, this.get(i, j));
                ++j;
            }
            ++i;
        }
        return tmp;
    }

    public Mat3f toMat3f() throws DimensionMismatchException {
        if (this.nRow() != 3 || this.nCol() != 3) {
            throw new DimensionMismatchException();
        }
        Mat3f tmp = new Mat3f();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                tmp.set(i, j, this.get(i, j));
                ++j;
            }
            ++i;
        }
        return tmp;
    }

    public Mat4f toMat4f() throws DimensionMismatchException {
        if (this.nRow() != 4 || this.nCol() != 4) {
            throw new DimensionMismatchException();
        }
        Mat4f tmp = new Mat4f();
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                tmp.set(i, j, this.get(i, j));
                ++j;
            }
            ++i;
        }
        return tmp;
    }
}

