/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem.linalg;

import gnu.gleem.linalg.DimensionMismatchException;
import gnu.gleem.linalg.Vec2f;
import gnu.gleem.linalg.Vec3f;
import gnu.gleem.linalg.Veci;

public class Vecf {
    private float[] data;

    public Vecf(int n) {
        this.data = new float[n];
    }

    public Vecf(Vecf arg) {
        this.data = new float[arg.data.length];
        System.arraycopy(arg.data, 0, this.data, 0, this.data.length);
    }

    public int length() {
        return this.data.length;
    }

    public float get(int i) {
        return this.data[i];
    }

    public void set(int i, float val) {
        this.data[i] = val;
    }

    public Vec2f toVec2f() throws DimensionMismatchException {
        if (this.length() != 2) {
            throw new DimensionMismatchException();
        }
        Vec2f out = new Vec2f();
        int i = 0;
        while (i < 2) {
            out.set(i, this.get(i));
            ++i;
        }
        return out;
    }

    public Vec3f toVec3f() throws DimensionMismatchException {
        if (this.length() != 3) {
            throw new DimensionMismatchException();
        }
        Vec3f out = new Vec3f();
        int i = 0;
        while (i < 3) {
            out.set(i, this.get(i));
            ++i;
        }
        return out;
    }

    public Veci toInt() {
        Veci out = new Veci(this.length());
        int i = 0;
        while (i < this.length()) {
            out.set(i, (int)this.get(i));
            ++i;
        }
        return out;
    }
}

