@ECHO OFF
REM ---------------------------------------------------------------------------
REM Create an Installer Package for GNUe Forms
REM 
REM $Id: setup.cmd 9713 2007-06-13 12:56:54Z johannes $
REM ---------------------------------------------------------------------------

REM ---------------------------------------------------------------------------
REM Prepare the build environment
REM ---------------------------------------------------------------------------

@ECHO Setting up the build environment ...
SET GNUE_PATH="C:\GNUE"

IF EXIST %GNUE_PATH% (
   RMDIR /S /Q %GNUE_PATH%
)
MKDIR %GNUE_PATH%
MKDIR %GNUE_PATH%\Scripts

COPY setup.py %GNUE_PATH%\Scripts
COPY gnue-32x32.ico %GNUE_PATH%\Scripts
COPY gnue-forms.iss %GNUE_PATH%\Scripts

REM ---------------------------------------------------------------------------
REM Install the package into the build environment
REM ---------------------------------------------------------------------------

CD ..\..
@ECHO Installing the package into local build environment ...

REM Note: We do *not* compile the py files here, because this would add a wrong
REM path to the pyc-files, which in turn breaks translations later.

python setup.py install --install-scripts=%GNUE_PATH%\Scripts --install-lib=%GNUE_PATH%\bin --install-data=%GNUE_PATH% --install-config=%GNUE_PATH%\etc --no-compile


REM ---------------------------------------------------------------------------
REM Compile everything into an exe
REM ---------------------------------------------------------------------------

CD packaging\win32

@ECHO Building EXE-File ...
PUSHD %GNUE_PATH%\Scripts

python setup.py py2exe -c -d %GNUE_PATH%\bin

POPD

REM Catch the built EXE and clean up the build environment
IF EXIST %GNUE_PATH%\dist\*.exe (
    COPY %GNUE_PATH%\dist\*.exe .
    RMDIR /S /Q %GNUE_PATH%
    @ECHO Package completed
)

:EXIT
