# GNU Enterprise Common - Setup Script for py2exe
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: setup.py 9956 2009-10-11 18:54:57Z reinhard $

import os
import sys
import py2exe
import win32api
import win32con

from distutils.core import setup

# -----------------------------------------------------------------------------
# Constants used by this setup
# -----------------------------------------------------------------------------

# The path where we are creating the build environment for the setup compiler
GNUE_PATH='C:\\GNUE'            
# The config files to rewrite (wrt line-ending)
CFG_FILES = []
# The InnoSetup configuration file
ISS_FILE = 'gnue-forms.iss'

# The manifest will be inserted as resource into .exe files.  This
# gives the controls the Windows XP appearance (if run on XP).
manifest = '''
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<assembly xmlns="urn:schemas-microsoft-com:asm.v1" manifestVersion="1.0">
<assemblyIdentity
    version="5.0.0.0"
    processorArchitecture="x86"
    name="Controls"
    type="win32"
/>
<description>GNU Enterprise</description>
<dependency>
    <dependentAssembly>
        <assemblyIdentity
            type="win32"
            name="Microsoft.Windows.Common-Controls"
            version="6.0.0.0"
            processorArchitecture="X86"
            publicKeyToken="6595b64144ccf1df"
            language="*"
        />
    </dependentAssembly>
</dependency>
</assembly>
'''

RT_MANIFEST = 24


# -----------------------------------------------------------------------------
# Create a list of all modules in the standard library
# -----------------------------------------------------------------------------

def getimports(libdir):
    """
    Returns a list of all modules in the standard python library.
    """
    importlist = []
    for entry in os.listdir(libdir):
        if entry.startswith('_') or '-' in entry or \
           entry.count('.')>1 or ' ' in entry:
            continue
    
        if not os.path.splitext(entry)[1] == '.py':
            continue

        importlist.append(entry[:entry.find('.')])

    return importlist


# -----------------------------------------------------------------------------
# Run the setup to create all the exe files in the gnue-common package
# -----------------------------------------------------------------------------
def create_exe_files():
    """
    Create gnue-schema.exe (which is currently the only exe supplied by
    gnue-common.
    """

    setup( \
        windows = [{"script": "gnue-forms",
                    "icon_resources": [(1, "gnue-32x32.ico")],
                    "other_resources": [(RT_MANIFEST, 1, manifest)]}],
        options = {"py2exe":
            {"dll_excludes": ["msvcp60.dll",
                              "tcl84.dll",
                              "tk84.dll",
                              "oci.dll"],
             "excludes": ["gnue.forms", "wx", "mx", "PIL"]
            }
        }
    )


# -----------------------------------------------------------------------------
# Finalize the build environment
# -----------------------------------------------------------------------------

def finalize_build_env():
    """
    Finalize the build environment ready to be processed by the setup compiler
    """

    for name in CFG_FILES:
        fhd = open(os.path.join(GNUE_PATH, 'etc', 'sample.%s' % name))
        data = [line.strip() for line in fhd.readlines()]
        out = open(os.path.join(GNUE_PATH, 'etc', name), 'wb')
        for line in data:
            out.write('%s%s' % (line, os.linesep))
        out.close()
        fhd.close()


# -----------------------------------------------------------------------------
# Examine the registry to find out where the InnoSetup compiler is located
# -----------------------------------------------------------------------------

def get_istool():
    root = win32con.HKEY_CLASSES_ROOT
    item = "InnoSetupScriptFile\\shell\\OpenWithISTool"
    try:
        path = None
        key = win32api.RegOpenKeyEx(root, item, 0, win32con.KEY_READ)
        value = win32api.RegQueryValue(key, "command")
        if isinstance(value, basestring):
            path = value.split(' ', 1)[0]
    except:
        pass

    return path

# -----------------------------------------------------------------------------
# Compile the setup
# -----------------------------------------------------------------------------

def compile_setup():
    
    istool = get_istool()
    if not istool:
        print "Cannot find ISTool.exe"
        sys.exit(1)

    cmd = '%s -compile %s' % (istool, ISS_FILE)
    os.system(cmd)


# =============================================================================
# Main program
# =============================================================================

create_exe_files()

finalize_build_env()

compile_setup()
