# GNU Enterprise Forms - GF Object Hierarchy - Component
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: GFComponent.py 9956 2009-10-11 18:54:57Z reinhard $
"""
Component support (bonobo for gtk2, ole for win32, etc.)
"""

from gnue.common import events
from gnue.forms.GFObjects.GFTabStop import GFFieldBound


# =============================================================================
# A component wrapper class
# =============================================================================

class GFComponent(GFFieldBound):

    # -------------------------------------------------------------------------
    # Constructor
    # -------------------------------------------------------------------------

    def __init__(self, parent=None):

        GFFieldBound.__init__(self, parent, 'GFComponent')

        # Default attributes (these may be replaced by parser)
        self.type = "URL"

    # -------------------------------------------------------------------------
    # Implementation of virtual methods
    # -------------------------------------------------------------------------

    def _phase_1_init_(self):
    
        GFFieldBound._phase_1_init_(self)

        if not hasattr(self, 'Char__height'):
            self.Char__height = int(gConfigForms('widgetHeight'))
