#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2009 Free Software Foundation
#
# FILE:
# uidrivers/html/widgets/entry.py
#
# DESCRIPTION:
#
# NOTES:
#

from gnue.forms.uidrivers.html.widgets._base import UIHelper, HtmlWidget
from gnue.forms.uidrivers.html.common import *
from gnue.forms.uidrivers.html.Generator import *

class UIEntry(UIHelper):

    def _create_widget(self, event, spacer):
        object = event.object
        id = getNextId()

        if object.style == 'dropdown' or \
          object.style == 'listbox':
            choices = []

            if object.style == "listbox":
                dhtml=build_entry_listbox(id, "%s", choices, object.Char__height,
                                           object.Char__x*event.widgetWidth,\
                                           self.itemY, self.itemWidth, \
                                           self.itemHeight)

            else:
                dhtml=build_entry_combobox(id, "%s", choices, object.Char__height,
                                           object.Char__x*event.widgetWidth,\
                                           self.itemY, self.itemWidth, \
                                           self.itemHeight)

        elif object.style == 'label':
            dhtml = build_entry_label(id, "%s", object.Char__x*event.widgetWidth, \
                                       self.itemY, self.itemWidth, self.itemHeight)

        elif object.style == 'checkbox':
            dhtml = build_entry_checkbox(id, "%s", object.label, \
                                         object.Char__x*event.widgetWidth, self.itemY)

        # multiline edit
        elif hasattr(object,'Char__height') and object.Char__height > 1:
            dhtml = build_entry_multiline(id, "%s", object.Char__height, \
                                          object.Char__x*event.widgetWidth,\
                                          self.itemY, self.itemWidth, \
                                          self.itemHeight)

        else: # normal text box - just digits
            textbox_style = "Textbox"
            # Textbox", IntegerTextbox, DateTextbox, TimeTextbox
            dhtml = build_entry_default(id, "%s", object.Char__x*event.widgetWidth,\
                                        self.itemY, self.itemWidth, self.itemHeight,
                                        textbox_style)
            # ["set_cursor", "141", 0], ["select_region", "141", [0, 0]]]



        newWidget = HtmlEntryWidget(event.container, self._uiDriver, 'ENTRY', dhtml, id)
        newWidget.style=object.style

        if object.style == 'dropdown' or object.style == 'listbox':
            newWidget.height = object.Char__height

        return newWidget

    # ---------------------------------------------------------------------------
    # Enable/disable this entry
    # ---------------------------------------------------------------------------

    def _ui_enable_(self, index):
        self.widgets[index].set_sensitive(True)

    # ---------------------------------------------------------------------------

    def _ui_disable_(self, index):
        self.widgets[index].set_sensitive(False)

    # ---------------------------------------------------------------------------
    # Set "editable" status for this widget
    # ---------------------------------------------------------------------------

    def _ui_set_editable_(self, index, editable):

        # FIXME: grey out entry, disallow changes if possible
        pass


    # ---------------------------------------------------------------------------
    # Set the cursor position in a widget to position
    # ---------------------------------------------------------------------------

    def _ui_set_cursor_position_ (self, index, position):

        widget = self.widgets [index]

        assert gDebug (6, "set_cursor_position to %s in %s [%s]" % \
            (position, widget, index))

        widget.set_cursor_pos(position)

    # -------------------------------------------------------------------------

    def _ui_copy_(self, index):

        widget = self.widgets[index]

        if hasattr(widget, 'copy_clipboard'):
            widget.copy_clipboard()

    # -------------------------------------------------------------------------

    def _ui_paste_(self, index):

        widget = self.widgets[index]

        if hasattr(widget, 'paste_clipboard'):
            widget.paste_clipboard()

    # -------------------------------------------------------------------------

    def _ui_select_all_(self, index):

        widget = self.widgets[index]

        if hasattr(widget, 'select_region'):
            widget.set_position(-1)
            pos = widget.get_position()
            widget.select_region(0, -1)
            bounds = widget.get_selection_bounds()
            # There seems to be no event that is fired when the selection of an
            # entry changes, so we must notify the GF layer ourselves.
            # FIXME: This also means that selecting "Select All" from the
            # context menu of the entry doesn't work.
            self._request('SELECTWITHMOUSE', position1=bounds[0],
                    position2=bounds[1], cursor=pos)



    # ---------------------------------------------------------------------------
    # set the selected area
    # ---------------------------------------------------------------------------

    def _ui_set_selected_area_ (self, index, selection1, selection2):

        assert gDebug (6, "Set Selected Area %s/%s in %s [%s]" % \
            (selection1, selection2, self, index))

        widget = self.widgets [index]
        widget.select_region (selection1, selection2)


    # ---------------------------------------------------------------------------
    # Update the list of allowed values on a combo or list widget
    # ---------------------------------------------------------------------------

    def _ui_set_choices_(self, index, choices):

        widget = self.widgets[index]

        # update HTML template
        if self._gfObject.style=="listbox":
            widget.dhtml=build_entry_listbox(widget._id, "%s", choices,
                                             self._gfObject.Char__height,
                                             self.itemX, self.itemY, self.itemWidth, \
                                             self.itemHeight)
        else:
            widget.dhtml=build_entry_combobox(widget._id, "%s", choices,
                                              self._gfObject.Char__height,
                                              self.itemX, self.itemY, self.itemWidth, \
                                              self.itemHeight)

        # send update to form
        widget.update_choices(choices)

    # -------------------------------------------------------------------------
    # Event handlers (called by GFController)
    # -------------------------------------------------------------------------

    def _on_text_changed(self, text, position=0):

        self._request('REPLACEVALUE', text=text, position=position)


class HtmlEntryWidget(HtmlWidget):

    def __repr__(self):
        return "Html Widget: %s" % self._type

    def set_cursor_pos(self, pos):
        self._send_update(["set_cursor","%s" % self._id, pos])

    def select_region(self, selection1, selection2):
        self._send_update(["select_region","%s" % self._id, \
                            [selection1, selection2]])

    def update_choices(self, choices):
        self._send_update(["update_choices","%s" % self._id, \
                            choices])

    def get_html(self):
        if self._type == "ENTRY":
            try:
                gfObject = self._uiDriver._WidgetToGFObj[self._id]
                if gfObject.style == 'checkbox':
                    if self.value:
                        return (self.dhtml % u"checked")
                    else:
                        return (self.dhtml % u"")
                else:
                    return (self.dhtml % self.value)

            except Exception,e:
                print e
                print self.dhtml,self.value
                return self.dhtml



configuration = {
    'baseClass'  : UIEntry,
    'provides'   : 'GFEntry',
    'container'  : 0,
  }
