# GNU Enterprise Forms - QT3 UI driver - VBox widgets
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: hbox.py 9956 2009-10-11 18:54:57Z reinhard $

import qt

from gnue.forms.uidrivers.qt3.widgets._base import ManagedBox

__all__ = ['UIHBox']

# =============================================================================
# Interface implementation for a box widget
# =============================================================================

class UIHBox(ManagedBox):
    """
    Implementation of the <hbox> tag
    """

    _vertical_ = False

    # -------------------------------------------------------------------------
    # Add an item to the box
    # -------------------------------------------------------------------------

    def add_widgets(self, ui_widget, spacer):
        """
        Add a given UI widget to the horizontal box

        @param ui_widget: the widget to be added
        @param spacer: not used for boxes
        """

        both = isinstance(ui_widget, ManagedBox)
        add = False

        if ui_widget.label:
            add = True
            self.sizer.addMultiCellWidget(ui_widget.label, 0, 0,
                    self.last_item, self.last_item)

        if ui_widget.widget:
            add = True

            span = 0
            if both and not ui_widget.label:
                span = 1

            row = self._entry_pos - 1
            self.sizer.addMultiCellWidget(ui_widget.widget, row, row+span,
                    self.last_item, self.last_item)

        if add and ui_widget.growable:
            self.sizer.setColStretch(self.last_item, ui_widget.stretch)

        self.last_item += int(add)


# =============================================================================
# Configuration
# =============================================================================

configuration = {
  'baseClass': UIHBox,
  'provides' : 'GFHBox',
  'container': 0
}
