#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2009 Free Software Foundation
#
# FILE:
# merge_rtf/Adapter.py
#
# DESCRIPTION:
#
# NOTES:
#

from gnue.reports.adapters.filters.MailMerge._merge import MergeBase
import string, sys



class TransformAdapter(MergeBase.TransformAdapter):

  NAME = "RTF"


  # What "command" separates new records?
  NEWRECORD = "\\page\r\n"
  NEWLINE = " "

  # The regex description of the beginning and end of the repeatable sections
  REGEX = r"\A(.*?)"                   \
        + r"(\\pard?.+)" \
        + r"(}\s*)\Z"

  # Comments...
  COMMENTABLE = 0        # Does this output format support comments?

  MIMETYPE = 'text/rtf'  # ????

  # Escape special characters
  def escape(self, s):
    if not len(s): return s
    part = s
    for char, replace in (('\\','\\\\'), ('{',r'\{'), ('}','\}'),
                          ('\t','\\tab ')):
      part = string.replace(part,char,replace)
    return part

