<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:gnue="GNUe:Reports:Base"
  xmlns:t="GNUe:Reports:SimpleTabulation"
  version="1.0">

<xsl:output method="text" indent="no"/>

<xsl:variable name="newline"><xsl:text>&#10;</xsl:text></xsl:variable>
<xsl:variable name="space80"><xsl:text>                                                                               </xsl:text></xsl:variable>
<xsl:variable name="doubleline80"><xsl:text>===============================================================================</xsl:text></xsl:variable>
<xsl:variable name="simpleline80"><xsl:text>-------------------------------------------------------------------------------</xsl:text></xsl:variable>

<xsl:template match="/">
  <xsl:call-template name="doReportTitle"/>
  <xsl:for-each select="gnue:report-output/t:report/t:section">
    <xsl:call-template name="doSectionTitle"/>
    <xsl:for-each select="t:table">
    
      <xsl:for-each select="t:tablehead">
        <xsl:for-each select="t:colhead">
          <xsl:call-template name="doColhead">
            <xsl:with-param name="colname"><xsl:value-of select="."/></xsl:with-param>
            <xsl:with-param name="colwidth"><xsl:value-of select="@width"/></xsl:with-param>
          </xsl:call-template>
        </xsl:for-each>
        <xsl:value-of select="$newline"/>
        <xsl:value-of select="$doubleline80"/>
        <xsl:value-of select="$newline"/>
      </xsl:for-each>
      
      <xsl:for-each select="t:row">
        <xsl:choose>
        <xsl:when test="@type='subtotal'">
          <xsl:value-of select="$simpleline80"/>
          <xsl:value-of select="$newline"/>
        </xsl:when>
        </xsl:choose>
        <xsl:for-each select="t:col">
          <xsl:call-template name="doRows">
            <xsl:with-param name="position"><xsl:value-of select="position()"/></xsl:with-param>
            <xsl:with-param name="align"><xsl:value-of select="@align"/></xsl:with-param>
            <xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
          </xsl:call-template>
        </xsl:for-each>
        <xsl:value-of select="$newline"/>
        <xsl:choose>
        <xsl:when test="@type='subtotal'">
          <xsl:value-of select="$newline"/>
        </xsl:when>
        </xsl:choose>
      </xsl:for-each>

    </xsl:for-each>
  </xsl:for-each>
</xsl:template>


<xsl:template name ="doReportTitle">
  <xsl:variable name='title' select="gnue:report-output/t:report/t:reportTitle"/>
  <xsl:value-of select="substring($space80, 1, (80 - string-length($title)) div 2)"/>
  <xsl:value-of select='$title'/>
  <xsl:value-of select="$newline"/>
  <xsl:value-of select="substring($space80, 1, (80 - string-length($title)) div 2)"/>
  <xsl:value-of select="substring($doubleline80, 1, string-length($title))"/>
  <xsl:value-of select="$newline"/>
</xsl:template>


<xsl:template name ="doSectionTitle">
  <xsl:variable name='title'><xsl:apply-templates select="t:sectionTitle"/></xsl:variable>
  <xsl:value-of select="substring($space80, 1, (80 - string-length($title)) div 2)"/>
  <xsl:value-of select='$title'/>
  <xsl:value-of select="$newline"/>
  <xsl:value-of select="substring($space80, 1, (80 - string-length($title)) div 2)"/>
  <xsl:value-of select="$newline"/>
</xsl:template>


<xsl:template name ="doColhead">
  <xsl:param name="colname"></xsl:param>
  <xsl:param name="colwidth"></xsl:param>
  <xsl:choose>
    <xsl:when test="@align='right'">
      <xsl:value-of select="substring($space80, 1, $colwidth - string-length(normalize-space($colname)))"/>
      <xsl:value-of select="normalize-space($colname)"/>
    </xsl:when>
    <xsl:when test="@align='center'">
      <xsl:value-of select="substring($space80, 1, ($colwidth - string-length(normalize-space($colname))) div 2)"/>
      <xsl:value-of select="normalize-space($colname)"/>
      <xsl:value-of select="substring($space80, 1, ($colwidth - string-length(normalize-space($colname))) div 2)"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="normalize-space($colname)"/>
      <xsl:value-of select="substring($space80, 1, $colwidth - string-length(normalize-space($colname)))"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name ="doRows">
  <xsl:param name='position' select="position()"/>
  <xsl:param name='align' select="@align"/>
  <xsl:param name='value' select="."/>
    <xsl:for-each select="/gnue:report-output/t:report/t:section/t:table/t:tablehead/t:colhead">
    <xsl:choose>
    <xsl:when test="position()=$position">
      <xsl:variable name="colwidth"><xsl:value-of select="@width"/></xsl:variable>
      <xsl:choose>
        <xsl:when test="$align='right'">
          <xsl:value-of select="substring($space80, 1, $colwidth - string-length(normalize-space($value)))"/>
          <xsl:value-of select="normalize-space($value)"/>
        </xsl:when>
        <xsl:when test="$align='center'">
          <xsl:value-of select="substring($space80, 1, ($colwidth - string-length(normalize-space($value))) div 2)"/>
          <xsl:value-of select="normalize-space($value)"/>
          <xsl:value-of select="substring($space80, 1, ($colwidth - string-length(normalize-space($value))) div 2)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="normalize-space($value)"/>
          <xsl:value-of select="substring($space80, 1, $colwidth - string-length(normalize-space($value)))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    </xsl:choose>
  </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
