/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.Declaration;
import gnu.expr.Language;
import gnu.expr.ScopeExp;
import gnu.kawa.util.GeneralHashTable;
import gnu.kawa.util.HashNode;
import gnu.mapping.Environment;
import gnu.mapping.Location;
import gnu.mapping.Symbol;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameLookup
extends GeneralHashTable<Object, Declaration> {
    Language language;
    static final Symbol KEY = Symbol.makeUninterned("<current-NameLookup>");

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public NameLookup(Language language) {
        this.language = language;
    }

    public static NameLookup getInstance(Environment env, Language language) {
        Location loc = env.getLocation(KEY);
        NameLookup nl = (NameLookup)loc.get(null);
        if (nl == null) {
            nl = new NameLookup(language);
            loc.set(nl);
        } else {
            nl.setLanguage(language);
        }
        return nl;
    }

    public static void setInstance(Environment env, NameLookup instance) {
        if (instance == null) {
            env.remove(KEY);
        } else {
            env.put(KEY, null, instance);
        }
    }

    public void push(Declaration decl) {
        Object symbol = decl.getSymbol();
        if (symbol == null) {
            return;
        }
        if (++this.num_bindings >= ((HashNode[])this.table).length) {
            this.rehash();
        }
        int hash = this.hash(symbol);
        Map.Entry node = this.makeEntry(symbol, hash, decl);
        int index = this.hashToIndex(hash);
        ((HashNode)node).next = ((HashNode[])this.table)[index];
        ((HashNode[])this.table)[index] = node;
    }

    public boolean pop(Declaration decl) {
        Object symbol = decl.getSymbol();
        if (symbol == null) {
            return false;
        }
        int hash = this.hash(symbol);
        HashNode prev = null;
        int index = this.hashToIndex(hash);
        HashNode node = ((HashNode[])this.table)[index];
        while (node != null) {
            HashNode next = node.next;
            if (node.getValue() == decl) {
                if (prev == null) {
                    ((HashNode[])this.table)[index] = next;
                } else {
                    prev.next = next;
                }
                --this.num_bindings;
                return true;
            }
            prev = node;
            node = next;
        }
        return false;
    }

    public void push(ScopeExp exp) {
        for (Declaration decl = exp.firstDecl(); decl != null; decl = decl.nextDecl()) {
            this.push(decl);
        }
    }

    public void pop(ScopeExp exp) {
        for (Declaration decl = exp.firstDecl(); decl != null; decl = decl.nextDecl()) {
            this.pop(decl);
        }
    }

    public void removeSubsumed(Declaration decl) {
        Object symbol = decl.getSymbol();
        int hash = this.hash(symbol);
        int index = this.hashToIndex(hash);
        HashNode prev = null;
        HashNode node = ((HashNode[])this.table)[index];
        while (node != null) {
            HashNode next = node.next;
            Declaration ndecl = (Declaration)node.getValue();
            if (ndecl != decl && this.subsumedBy(decl, ndecl)) {
                if (prev == null) {
                    ((HashNode[])this.table)[index] = next;
                } else {
                    prev.next = next;
                }
            } else {
                prev = node;
            }
            node = next;
        }
    }

    protected boolean subsumedBy(Declaration decl, Declaration other) {
        return decl.getSymbol() == other.getSymbol() && (this.language.getNamespaceOf(decl) & this.language.getNamespaceOf(other)) != 0;
    }

    public Declaration lookup(Object symbol, int namespace) {
        int hash = this.hash(symbol);
        int index = this.hashToIndex(hash);
        HashNode node = ((HashNode[])this.table)[index];
        while (node != null) {
            Declaration decl = (Declaration)node.getValue();
            if (symbol.equals(decl.getSymbol()) && this.language.hasNamespace(decl, namespace)) {
                return decl;
            }
            node = node.next;
        }
        return null;
    }

    public Declaration lookup(Object symbol, boolean function2) {
        return this.lookup(symbol, function2 ? 2 : 1);
    }
}

