/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.mapping.WrappedException;
import gnu.text.Path;
import gnu.text.ResourceStreamHandler;
import gnu.text.URIPath;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

public class URLPath
extends URIPath {
    final URL url;

    URLPath(URL url) {
        super(URLPath.toUri(url));
        this.url = url;
    }

    public static URLPath valueOf(URL url) {
        return new URLPath(url);
    }

    public boolean isAbsolute() {
        return true;
    }

    public long getLastModified() {
        return URLPath.getLastModified(this.url);
    }

    public static long getLastModified(URL url) {
        try {
            return url.openConnection().getLastModified();
        }
        catch (Throwable ex) {
            return 0L;
        }
    }

    public long getContentLength() {
        return URLPath.getContentLength(this.url);
    }

    public static int getContentLength(URL url) {
        try {
            return url.openConnection().getContentLength();
        }
        catch (Throwable ex) {
            return -1;
        }
    }

    public URL toURL() {
        return this.url;
    }

    public static URI toUri(URL url) {
        try {
            return url.toURI();
        }
        catch (Throwable ex) {
            throw WrappedException.wrapIfNeeded(ex);
        }
    }

    public URI toUri() {
        return URLPath.toUri(this.url);
    }

    public String toURIString() {
        return this.url.toString();
    }

    public Path resolve(String relative) {
        try {
            return URLPath.valueOf(new URL(this.url, relative));
        }
        catch (Throwable ex) {
            throw WrappedException.wrapIfNeeded(ex);
        }
    }

    public static InputStream openInputStream(URL url) throws IOException {
        return url.openConnection().getInputStream();
    }

    public InputStream openInputStream() throws IOException {
        return URLPath.openInputStream(this.url);
    }

    public static OutputStream openOutputStream(URL url) throws IOException {
        String str = url.toString();
        if (str.startsWith("file:")) {
            try {
                return new FileOutputStream(new File(new URI(str)));
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        URLConnection conn = url.openConnection();
        conn.setDoInput(false);
        conn.setDoOutput(true);
        return conn.getOutputStream();
    }

    public OutputStream openOutputStream() throws IOException {
        return URLPath.openOutputStream(this.url);
    }

    public static URLPath classResourcePath(Class clas) {
        URL url;
        try {
            try {
                url = ResourceStreamHandler.makeURL(clas);
            }
            catch (SecurityException ex) {
                String classFileName = clas.getName().replace('.', '/') + ".class";
                url = clas.getClassLoader().getResource(classFileName);
            }
        }
        catch (Throwable ex) {
            throw WrappedException.wrapIfNeeded(ex);
        }
        return URLPath.valueOf(url);
    }
}

