/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.EFrame;
import gnu.jemacs.buffer.EWindow;
import gnu.jemacs.lang.ELisp;
import gnu.lists.FString;
import gnu.mapping.Environment;
import gnu.mapping.Namespace;
import gnu.mapping.Symbol;
import gnu.math.IntNum;

public class Command {
    static Object resolveSymbol(Object command) {
        int count = 100;
        do {
            if (command instanceof String) {
                command = Namespace.getDefaultSymbol((String)command);
            }
            if (command instanceof Symbol) {
                Symbol sym = (Symbol)command;
                Environment env = Environment.getCurrent();
                command = env.getFunction(sym, null);
                if (command != null) continue;
                command = env.get(sym, null);
                continue;
            }
            return command;
        } while (--count >= 0);
        throw new Error("circular binding for " + command);
    }

    public static void perform(Object command) {
        Command.perform(command, EWindow.getSelected());
    }

    public static void perform(Object command, EWindow window) {
        window.handleCommand(command);
    }

    public static Object[] processInteractionString(String str) {
        int len = str.length();
        int i = 0;
        int start = 0;
        int argCount = 0;
        Buffer buffer = Buffer.getCurrent();
        block13: while (i < len) {
            char ch = str.charAt(i++);
            switch (ch) {
                case '\n': {
                    continue block13;
                }
                case '@': {
                    if (start != i - 1) continue block13;
                    start = i;
                    continue block13;
                }
                case '*': {
                    if (start != i - 1) continue block13;
                    start = i;
                    continue block13;
                }
                case '_': {
                    if (start != i - 1) continue block13;
                    start = i;
                    continue block13;
                }
                case 'r': {
                    ++argCount;
                }
            }
            ++argCount;
            while (i < len && (ch = str.charAt(i++)) != '\n') {
            }
        }
        Object[] args = new Object[argCount];
        int argIndex = 0;
        i = start;
        block15: while (i < len) {
            int promptLength;
            int promptStart;
            char ch;
            block18: {
                char c;
                ch = str.charAt(i++);
                promptStart = i;
                do {
                    if (i < len) continue;
                    promptLength = i - promptStart;
                    break block18;
                } while ((c = str.charAt(i++)) != '\n');
                promptLength = i - 1 - promptStart;
            }
            switch (ch) {
                case 'P': {
                    args[argIndex++] = ELisp.FALSE;
                    continue block15;
                }
                case 'p': {
                    args[argIndex++] = IntNum.one();
                    continue block15;
                }
                case 'r': {
                    int mark = buffer.checkMark() + 1;
                    int point = buffer.getPoint();
                    if (mark <= point) {
                        args[argIndex++] = IntNum.make(mark);
                        args[argIndex++] = IntNum.make(point);
                        continue block15;
                    }
                    args[argIndex++] = IntNum.make(point);
                    args[argIndex++] = IntNum.make(mark);
                    continue block15;
                }
                case 'F': 
                case 'S': 
                case 's': {
                    String answer = EFrame.selectedFrame.ask(str.substring(promptStart, promptStart + promptLength));
                    args[argIndex++] = ch == 'S' ? answer.intern() : new FString(answer);
                    continue block15;
                }
            }
            System.err.println("un-implemented interactive prompt:" + ch);
            args[argIndex++] = ELisp.FALSE;
        }
        return args;
    }
}

