/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.mapping.Procedure0;
import java.lang.reflect.Field;

public class StaticGet
extends Procedure0
implements Inlineable {
    ClassType ctype;
    String fname;
    gnu.bytecode.Field field;
    Field reflectField;

    StaticGet(Class clazz, String string) {
        this.ctype = (ClassType)Type.make(clazz);
        this.fname = string;
    }

    public StaticGet(ClassType classType, String string, Type type, int n) {
        this.ctype = classType;
        this.fname = string;
        this.field = classType.getField(string);
        if (this.field == null) {
            this.field = classType.addField(string, type, n);
        }
    }

    public Object apply0() {
        if (this.reflectField == null) {
            Class clazz = this.ctype.getReflectClass();
            try {
                this.reflectField = clazz.getField(this.fname);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException("no such field " + this.fname + " in " + clazz.getName());
            }
        }
        try {
            return this.reflectField.get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("illegal access for field " + this.fname);
        }
    }

    private gnu.bytecode.Field getField() {
        if (this.field == null) {
            this.field = this.ctype.getField(this.fname);
            if (this.field == null) {
                this.field = this.ctype.addField(this.fname, Type.make(this.reflectField.getType()), this.reflectField.getModifiers());
            }
        }
        return this.field;
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        this.getField();
        CodeAttr codeAttr = compilation.getCode();
        codeAttr.emitGetStatic(this.field);
        target.compileFromStack(compilation, this.field.getType());
    }

    public Type getReturnType(Expression[] expressionArray) {
        return this.getField().getType();
    }
}

