/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xslt;

import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.kawa.xml.Document;
import gnu.kawa.xml.Focus;
import gnu.kawa.xml.XMLParser;
import gnu.kawa.xslt.TemplateTable;
import gnu.kawa.xslt.XslTranslator;
import gnu.lists.Consumer;
import gnu.lists.TreeList;
import gnu.mapping.CallContext;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.text.Lexer;
import gnu.text.LineBufferedReader;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.xquery.lang.XQParser;
import gnu.xquery.lang.XQuery;
import java.io.IOException;
import java.util.Vector;
import kawa.repl;

public class XSLT
extends XQuery {
    static XSLT instance;
    public static Symbol nullMode;

    public String getName() {
        return "XSLT";
    }

    public XSLT() {
        instance = this;
        ModuleBody.setMainPrintValues(true);
        Environment.setCurrent(this.getEnvironment());
    }

    public static XSLT getXsltInstance() {
        if (instance == null) {
            new XSLT();
        }
        return instance;
    }

    Expression parseXPath(String string, SourceMessages sourceMessages) {
        try {
            Expression expression;
            Compilation compilation = new Compilation(sourceMessages);
            XQParser xQParser = (XQParser)super.getLexer(new CharArrayInPort(string), sourceMessages);
            Vector<Expression> vector = new Vector<Expression>(20);
            while ((expression = xQParser.parse(compilation)) != null) {
                vector.addElement(expression);
            }
            int n = vector.size();
            if (n == 0) {
                return QuoteExp.voidExp;
            }
            if (n == 1) {
                return (Expression)vector.elementAt(0);
            }
            throw new InternalError("too many xpath expressions");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new InternalError("caught " + throwable);
        }
    }

    public Lexer getLexer(InPort inPort, SourceMessages sourceMessages) {
        return new XslTranslator(inPort, sourceMessages, this);
    }

    public Compilation parse(Environment environment, Lexer lexer) throws IOException, SyntaxException {
        lexer.clearErrors();
        Compilation.usingTailCalls = true;
        SourceMessages sourceMessages = lexer.getMessages();
        Compilation compilation = new Compilation(sourceMessages);
        compilation.immediate = true;
        ModuleExp moduleExp = new ModuleExp();
        moduleExp.setFile(lexer.getName());
        compilation.push(moduleExp);
        compilation.mustCompileHere();
        XslTranslator xslTranslator = (XslTranslator)lexer;
        xslTranslator.beginDocument(moduleExp);
        XMLParser xMLParser = new XMLParser(lexer.getPort(), sourceMessages, (Consumer)xslTranslator);
        xMLParser.parse();
        xslTranslator.endDocument();
        compilation.pop(moduleExp);
        return compilation;
    }

    public Compilation parseFile(InPort inPort, boolean bl, SourceMessages sourceMessages) throws IOException, SyntaxException {
        Compilation.usingTailCalls = true;
        Compilation compilation = new Compilation(sourceMessages);
        compilation.immediate = bl;
        compilation.mustCompileHere();
        ModuleExp moduleExp = new ModuleExp();
        moduleExp.setFile(inPort.getName());
        compilation.push(moduleExp);
        XslTranslator xslTranslator = new XslTranslator(moduleExp, sourceMessages, this);
        xslTranslator.beginDocument();
        XMLParser xMLParser = new XMLParser((LineBufferedReader)inPort, sourceMessages, (Consumer)xslTranslator);
        xMLParser.parse();
        xslTranslator.endDocument();
        compilation.pop(moduleExp);
        return compilation;
    }

    public static void registerEnvironment() {
        XSLT xSLT = new XSLT();
        Interpreter.defaultInterpreter = xSLT;
        Environment.setCurrent(xSLT.getEnvironment());
    }

    public static void defineCallTemplate(Symbol symbol, double d, Procedure procedure) {
    }

    public static void defineApplyTemplate(String string, double d, Symbol symbol, Procedure procedure) {
        if (symbol == null) {
            symbol = nullMode;
        }
        TemplateTable templateTable = TemplateTable.getTemplateTable(symbol);
        templateTable.enter(string, d, procedure);
    }

    public static void defineTemplate(Symbol symbol, String string, double d, Symbol symbol2, Procedure procedure) {
        if (symbol != null) {
            XSLT.defineCallTemplate(symbol, d, procedure);
        }
        if (string != null) {
            XSLT.defineApplyTemplate(string, d, symbol2, procedure);
        }
    }

    public static void process(TreeList treeList, Focus focus, CallContext callContext) throws Throwable {
        Consumer consumer = callContext.consumer;
        while (true) {
            int n = focus.ipos;
            int n2 = treeList.getNextKind(n);
            switch (n2) {
                case 34: {
                    n = treeList.firstChildPos(n);
                    break;
                }
                case 33: {
                    Object object2 = focus.getNextTypeObject();
                    Procedure procedure = TemplateTable.nullModeTable.find(focus.getNextTypeName());
                    String string = focus.getNextTypeName();
                    if (procedure != null) {
                        procedure.apply(callContext);
                    } else {
                        consumer.beginGroup(string, object2);
                        focus.push(treeList, treeList.firstChildPos(n));
                        XSLT.process(treeList, focus, callContext);
                        focus.pop();
                        consumer.endGroup(string);
                    }
                    n = treeList.nextDataIndex(n >>> 1) << 1;
                    focus.gotoNext();
                    break;
                }
                case 29: {
                    int n3 = n >>> 1;
                    int n4 = treeList.nextNodeIndex(n3, Integer.MAX_VALUE);
                    if (n == n4) {
                        n4 = treeList.nextDataIndex(n3);
                    }
                    treeList.consumeIRange(n3, n4, consumer);
                    n = n4 << 1;
                    break;
                }
                default: {
                    return;
                }
            }
            focus.ipos = n;
        }
    }

    public static void runStylesheet() throws Throwable {
        CallContext callContext = CallContext.getInstance();
        String string = CallContext.getBaseUriDefault();
        String[] stringArray = repl.commandLineArgArray;
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            TreeList treeList = Document.parse(Document.makeURL(string2, string));
            Focus focus = Focus.getCurrent();
            focus.push(treeList, 0);
            XSLT.process(treeList, focus, callContext);
            ++n;
        }
    }

    public static void applyTemplates(String string, Symbol symbol) throws Throwable {
        if (symbol == null) {
            symbol = nullMode;
        }
        TemplateTable templateTable = TemplateTable.getTemplateTable(symbol);
        CallContext callContext = CallContext.getInstance();
        Focus focus = Focus.getCurrent();
        TreeList treeList = (TreeList)focus.sequence;
        focus.push(treeList, treeList.firstChildPos(focus.ipos));
        XSLT.process(treeList, focus, callContext);
        focus.pop();
    }

    static {
        nullMode = Symbol.make(null, "");
    }
}

