/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.Member;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Language;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.kawa.functions.GetNamedExp;
import gnu.kawa.functions.GetNamedInstancePart;
import gnu.kawa.functions.NamedPart;
import gnu.kawa.functions.SetNamedPart;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.reflect.SlotGet;
import gnu.mapping.Environment;
import gnu.mapping.HasNamedParts;
import gnu.mapping.HasSetter;
import gnu.mapping.MethodProc;
import gnu.mapping.Namespace;
import gnu.mapping.Procedure;
import gnu.mapping.Procedure2;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import kawa.lang.Translator;

public class GetNamedPart
extends Procedure2
implements HasSetter,
CanInline {
    public static final GetNamedPart getNamedPart = new GetNamedPart();
    public static final String CLASSTYPE_FOR = "<>";
    public static final String CAST_METHOD_NAME = "@";
    public static final String INSTANCEOF_METHOD_NAME = "instance?";
    static final ClassType typeHasNamedParts = ClassType.make("gnu.mapping.HasNamedParts");

    public static String combineName(Expression part1, Expression part2) {
        String name1;
        Object name2;
        if (part2 instanceof QuoteExp && (name2 = ((QuoteExp)part2).getValue()) instanceof String && (part1 instanceof ReferenceExp && (name1 = ((ReferenceExp)part1).getSimpleName()) != null || part1 instanceof GetNamedExp && (name1 = ((GetNamedExp)part1).combinedName) != null)) {
            return (name1 + ':' + name2).intern();
        }
        return null;
    }

    public static Expression makeExp(Expression clas, Expression member) {
        ReferenceExp rexp;
        String combinedName = GetNamedPart.combineName(clas, member);
        if (combinedName != null) {
            Translator tr = (Translator)Compilation.getCurrent();
            Declaration decl = tr.lexical.lookup((Object)combinedName, false);
            if (!Declaration.isUnknown(decl)) {
                return new ReferenceExp(decl);
            }
            Environment env = Environment.getCurrent();
            Symbol symbol = env.defaultNamespace().lookup(combinedName);
            Object property = null;
            if (symbol != null && env.isBound(symbol, property)) {
                return new ReferenceExp((Object)combinedName);
            }
        }
        if (clas instanceof ReferenceExp && (rexp = (ReferenceExp)clas).isUnknown()) {
            String name = rexp.getName();
            try {
                Class<?> cl = Class.forName(name, false, clas.getClass().getClassLoader());
                clas = QuoteExp.getInstance(Type.make(cl));
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        Expression[] args = new Expression[]{clas, member};
        GetNamedExp exp = new GetNamedExp(args);
        exp.combinedName = combinedName;
        return exp;
    }

    public static Expression makeExp(Expression clas, String member) {
        return GetNamedPart.makeExp(clas, new QuoteExp((Object)member));
    }

    public static Expression makeExp(Type type, String member) {
        return GetNamedPart.makeExp((Expression)new QuoteExp(type), new QuoteExp((Object)member));
    }

    public Expression inline(ApplyExp exp, ExpWalker walker) {
        Expression[] args = exp.getArgs();
        if (args.length != 2 || !(args[1] instanceof QuoteExp) || !(exp instanceof GetNamedExp)) {
            return exp;
        }
        Expression context = args[0];
        Declaration decl = null;
        if (context instanceof ReferenceExp) {
            ReferenceExp rexp = (ReferenceExp)context;
            if ("*".equals(rexp.getName())) {
                return GetNamedInstancePart.makeExp(args[1]);
            }
            decl = rexp.getBinding();
        }
        String mname = ((QuoteExp)args[1]).getValue().toString();
        Type type = context.getType();
        boolean isInstanceOperator = context == QuoteExp.nullExp;
        Compilation comp = walker.getCompilation();
        Language language = comp.getLanguage();
        Type typeval = language.getTypeFor(context, false);
        ClassType caller = comp == null ? null : (comp.curClass != null ? comp.curClass : comp.mainClass);
        GetNamedExp nexp = (GetNamedExp)exp;
        if (typeval instanceof Type) {
            if (mname.equals(CLASSTYPE_FOR)) {
                return new QuoteExp(typeval);
            }
            if (typeval instanceof ObjectType) {
                if (mname.equals("new")) {
                    return nexp.setProcedureKind('N');
                }
                if (mname.equals(INSTANCEOF_METHOD_NAME)) {
                    return nexp.setProcedureKind('I');
                }
                if (mname.equals(CAST_METHOD_NAME)) {
                    return nexp.setProcedureKind('C');
                }
            }
        }
        if (typeval instanceof ClassType) {
            if (mname.length() > 1 && mname.charAt(0) == '.') {
                return new QuoteExp(new NamedPart(typeval, mname, 'D'));
            }
            if (Invoke.checkKnownClass(typeval, comp) < 0) {
                return exp;
            }
            PrimProcedure[] methods = ClassMethods.getMethods((ClassType)typeval, Compilation.mangleName(mname), '\u0000', caller, language);
            if (methods != null && methods.length > 0) {
                nexp.methods = methods;
                return nexp.setProcedureKind('S');
            }
            ApplyExp aexp = new ApplyExp(SlotGet.staticField, args);
            aexp.setLine(exp);
            return ((InlineCalls)walker).walkApplyOnly(aexp);
        }
        if (typeval != null) {
            // empty if block
        }
        if (type.isSubtype(Compilation.typeClassType) || type.isSubtype(Type.java_lang_Class_type)) {
            return exp;
        }
        if (type instanceof ObjectType) {
            ObjectType otype = (ObjectType)type;
            ClassType ctype = type instanceof ClassType ? (ClassType)type : Type.pointer_type;
            PrimProcedure[] methods = ClassMethods.getMethods(otype, Compilation.mangleName(mname), 'V', caller, language);
            if (methods != null && methods.length > 0) {
                nexp.methods = methods;
                return nexp.setProcedureKind('M');
            }
            Member part = SlotGet.lookupMember(ctype, mname, caller);
            if (part != null || mname.equals("length") && type instanceof ArrayType) {
                ApplyExp aexp = new ApplyExp(SlotGet.field, args);
                aexp.setLine(exp);
                return ((InlineCalls)walker).walkApplyOnly(aexp);
            }
            if (type.isSubtype(typeHasNamedParts)) {
                HasNamedParts value;
                Object val;
                if (decl != null && (val = Declaration.followAliases(decl).getConstantValue()) != null && (value = (HasNamedParts)val).isConstant(mname)) {
                    val = value.get(mname);
                    return QuoteExp.getInstance(val);
                }
                return new ApplyExp(typeHasNamedParts.getDeclaredMethod("get", 1), args).setLine(exp);
            }
        }
        if (comp.getBooleanOption("warn-invoke-unknown-method", !comp.immediate)) {
            comp.error('w', "no known slot '" + mname + "' in " + type.getName());
        }
        return exp;
    }

    public Object apply2(Object container, Object part) throws Throwable {
        if (container instanceof Values) {
            Object[] values = ((Values)container).getValues();
            Values result = new Values();
            for (int i = 0; i < values.length; ++i) {
                Values.writeValues(this.apply2(values[i], part), result);
            }
            return result.canonicalize();
        }
        Symbol sym = part instanceof Symbol ? (Symbol)part : Namespace.EmptyNamespace.getSymbol(part.toString().intern());
        return GetNamedPart.getNamedPart(container, sym);
    }

    public static Object getTypePart(Type type, String name) throws Throwable {
        if (name.equals(CLASSTYPE_FOR)) {
            return type;
        }
        if (type instanceof ObjectType) {
            if (name.equals(INSTANCEOF_METHOD_NAME)) {
                return new NamedPart(type, name, 'I');
            }
            if (name.equals(CAST_METHOD_NAME)) {
                return new NamedPart(type, name, 'C');
            }
            if (name.equals("new")) {
                return new NamedPart(type, name, 'N');
            }
            if (name.equals(".length") || name.length() > 1 && name.charAt(0) == '.' && type instanceof ClassType) {
                return new NamedPart(type, name, 'D');
            }
        }
        if (type instanceof ClassType) {
            try {
                return SlotGet.staticField(type, name);
            }
            catch (Throwable throwable) {
                return ClassMethods.apply(ClassMethods.classMethods, type, name);
            }
        }
        return GetNamedPart.getMemberPart(type, name);
    }

    public static Object getNamedPart(Object container, Symbol part) throws Throwable {
        String name = part.getName();
        if (container instanceof HasNamedParts) {
            return ((HasNamedParts)container).get(name);
        }
        if (container instanceof Class) {
            container = (ClassType)Type.make((Class)container);
        }
        if (container instanceof Type) {
            return GetNamedPart.getTypePart((Type)container, name);
        }
        return GetNamedPart.getMemberPart(container, part.toString());
    }

    public static Object getMemberPart(Object container, String name) throws Throwable {
        try {
            return SlotGet.field(container, name);
        }
        catch (Throwable ex) {
            MethodProc methods = ClassMethods.apply((ClassType)ClassType.make(container.getClass()), Compilation.mangleName(name), '\u0000', Language.getDefaultLanguage());
            if (methods != null) {
                return new NamedPart(container, name, 'M', methods);
            }
            throw new RuntimeException("no part '" + name + "' in " + container);
        }
    }

    public Procedure getSetter() {
        return SetNamedPart.setNamedPart;
    }
}

