/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.ElementPredicate;
import gnu.lists.SeqPosition;
import gnu.lists.Sequence;
import gnu.lists.SubSequence;
import gnu.lists.TreePosition;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractSequence {
    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int rank() {
        return 1;
    }

    public abstract Object get(int var1);

    public int getEffectiveIndex(int[] nArray) {
        return nArray[0];
    }

    public Object get(int[] nArray) {
        return this.get(nArray[0]);
    }

    public Object set(int[] nArray, Object object2) {
        return this.set(nArray[0], object2);
    }

    public int getLowBound(int n) {
        return 0;
    }

    public int getSize(int n) {
        return n == 0 ? this.size() : 1;
    }

    protected RuntimeException unsupported(String string) {
        string = this.getClass().getName() + " does not implement " + string;
        return new UnsupportedOperationException(string);
    }

    public AbstractSequence append(char c) {
        throw this.unsupported("append");
    }

    public Object set(int n, Object object2) {
        throw this.unsupported("set");
    }

    public void fill(Object object2) {
        int n = this.startPos();
        while ((n = this.nextPos(n)) != 0) {
            this.setPosPrevious(n, object2);
        }
    }

    public void fillPosRange(int n, int n2, Object object2) {
        int n3 = this.copyPos(n);
        while (this.compare(n3, n2) < 0) {
            this.setPosNext(n3, object2);
            n3 = this.nextPos(n3);
        }
        this.releasePos(n3);
    }

    public void fill(int n, int n2, Object object2) {
        int n3 = this.createPos(n, false);
        int n4 = this.createPos(n2, true);
        while (this.compare(n3, n4) < 0) {
            this.setPosNext(n3, object2);
            n3 = this.nextPos(n3);
        }
        this.releasePos(n3);
        this.releasePos(n4);
    }

    public int indexOf(Object object2) {
        int n = 0;
        int n2 = this.startPos();
        while ((n2 = this.nextPos(n2)) != 0) {
            Object object3 = this.getPosPrevious(n2);
            if (object2 == null ? object3 == null : object2.equals(object3)) {
                this.releasePos(n2);
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastIndexOf(Object object2) {
        int n = this.size();
        while (--n >= 0) {
            Object object3 = this.get(n);
            if (!(object2 == null ? object3 == null : object2.equals(object3))) continue;
            return n;
        }
        return -1;
    }

    public int nextMatching(int n, ElementPredicate elementPredicate, int n2, boolean bl) {
        if (bl) {
            throw this.unsupported("nextMatching with descend");
        }
        int n3 = n;
        do {
            if (this.compare(n3, n2) < 0) continue;
            return 0;
        } while (!elementPredicate.isInstancePos(this, n3 = this.nextPos(n3)));
        return n3;
    }

    public boolean contains(Object object2) {
        return this.indexOf(object2) >= 0;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    public final Enumeration elements() {
        return this.getIterator();
    }

    public final SeqPosition getIterator() {
        return this.getIterator(0);
    }

    public SeqPosition getIterator(int n) {
        return new SeqPosition(this, n, false);
    }

    public SeqPosition getIteratorAtPos(int n) {
        return new SeqPosition(this, this.copyPos(n));
    }

    public final Iterator iterator() {
        return this.getIterator();
    }

    public final ListIterator listIterator() {
        return this.getIterator(0);
    }

    public final ListIterator listIterator(int n) {
        return this.getIterator(n);
    }

    protected int addPos(int n, Object object2) {
        throw this.unsupported("addPos");
    }

    public boolean add(Object object2) {
        this.addPos(this.endPos(), object2);
        return true;
    }

    public void add(int n, Object object2) {
        int n2 = this.createPos(n, false);
        this.addPos(n2, object2);
        this.releasePos(n2);
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    public boolean addAll(int n, Collection collection) {
        boolean bl = false;
        int n2 = this.createPos(n, false);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            n2 = this.addPos(n2, iterator.next());
            bl = true;
        }
        this.releasePos(n2);
        return bl;
    }

    public void removePos(int n, int n2) {
        int n3 = this.createRelativePos(n, n2, false);
        if (n2 >= 0) {
            this.removePosRange(n, n3);
        } else {
            this.removePosRange(n3, n);
        }
        this.releasePos(n3);
    }

    protected void removePosRange(int n, int n2) {
        throw this.unsupported("removePosRange");
    }

    public Object remove(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.createPos(n, false);
        Object object2 = this.getPosNext(n2);
        this.removePos(n2, 1);
        this.releasePos(n2);
        return object2;
    }

    public boolean remove(Object object2) {
        int n = this.indexOf(object2);
        if (n < 0) {
            return false;
        }
        int n2 = this.createPos(n, false);
        this.removePos(n2, 1);
        this.releasePos(n2);
        return true;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        int n = this.startPos();
        while ((n = this.nextPos(n)) != 0) {
            Object object2 = this.getPosPrevious(n);
            if (!collection.contains(object2)) continue;
            this.removePos(n, -1);
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        int n = this.startPos();
        while ((n = this.nextPos(n)) != 0) {
            Object object2 = this.getPosPrevious(n);
            if (collection.contains(object2)) continue;
            this.removePos(n, -1);
            bl = true;
        }
        return bl;
    }

    public void clear() {
        this.removePos(this.startPos(), this.endPos());
    }

    protected boolean isAfterPos(int n) {
        return (n & 1) != 0;
    }

    public abstract int createPos(int var1, boolean var2);

    public int createRelativePos(int n, int n2, boolean bl) {
        return this.createPos(this.nextIndex(n) + n2, bl);
    }

    public int startPos() {
        return 0;
    }

    public int endPos() {
        return -1;
    }

    protected void releasePos(int n) {
    }

    public int copyPos(int n) {
        return n;
    }

    protected int getIndexDifference(int n, int n2) {
        return this.nextIndex(n) - this.nextIndex(n2);
    }

    protected int nextIndex(int n) {
        return this.getIndexDifference(n, this.startPos());
    }

    protected int fromEndIndex(int n) {
        return this.size() - this.nextIndex(n);
    }

    protected int getContainingSequenceSize(int n) {
        return this.size();
    }

    public boolean hasNext(int n) {
        return this.nextIndex(n) != this.size();
    }

    public int getNextKind(int n) {
        return this.hasNext(n) ? 32 : 0;
    }

    public String getNextTypeName(int n) {
        return null;
    }

    public Object getNextTypeObject(int n) {
        return null;
    }

    protected boolean hasPrevious(int n) {
        return this.nextIndex(n) != 0;
    }

    public int nextPos(int n) {
        if (!this.hasNext(n)) {
            return 0;
        }
        int n2 = this.createRelativePos(n, 1, true);
        this.releasePos(n);
        return n2;
    }

    public int previousPos(int n) {
        if (!this.hasPrevious(n)) {
            return 0;
        }
        int n2 = this.createRelativePos(n, -1, false);
        this.releasePos(n);
        return n2;
    }

    public final boolean gotoChildrenStart(TreePosition treePosition) {
        int n = this.firstChildPos(treePosition.getPos());
        if (n == 0) {
            return false;
        }
        treePosition.push(this, n);
        return true;
    }

    public int firstChildPos(int n) {
        return 0;
    }

    public int firstAttributePos(int n) {
        return 0;
    }

    public int parentPos(int n) {
        return this.endPos();
    }

    protected boolean gotoParent(TreePosition treePosition) {
        if (treePosition.depth < 0) {
            return false;
        }
        treePosition.pop();
        return true;
    }

    public int getAttributeLength() {
        return 0;
    }

    public Object getAttribute(int n) {
        return null;
    }

    protected boolean gotoAttributesStart(TreePosition treePosition) {
        return false;
    }

    public Object getPosNext(int n) {
        if (!this.hasNext(n)) {
            return Sequence.eofValue;
        }
        return this.get(this.nextIndex(n));
    }

    public Object getPosPrevious(int n) {
        int n2 = this.nextIndex(n);
        if (n2 <= 0) {
            return Sequence.eofValue;
        }
        return this.get(n2 - 1);
    }

    protected void setPosNext(int n, Object object2) {
        int n2 = this.nextIndex(n);
        if (n2 >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.set(n2, object2);
    }

    protected void setPosPrevious(int n, Object object2) {
        int n2 = this.nextIndex(n);
        if (n2 == 0) {
            throw new IndexOutOfBoundsException();
        }
        this.set(n2 - 1, object2);
    }

    public final int nextIndex(SeqPosition seqPosition) {
        return this.nextIndex(seqPosition.ipos);
    }

    public Object baseUriOfPos(int n) {
        return null;
    }

    public boolean equals(int n, int n2) {
        return this.compare(n, n2) == 0;
    }

    public int compare(int n, int n2) {
        int n3;
        int n4 = this.nextIndex(n);
        return n4 < (n3 = this.nextIndex(n2)) ? -1 : (n4 > n3 ? 1 : 0);
    }

    public final int compare(SeqPosition seqPosition, SeqPosition seqPosition2) {
        return this.compare(seqPosition.ipos, seqPosition2.ipos);
    }

    public Object[] toArray() {
        int n = this.size();
        Object[] objectArray = new Object[n];
        int n2 = this.startPos();
        int n3 = 0;
        while ((n2 = this.nextPos(n2)) != 0) {
            objectArray[n3++] = this.getPosPrevious(n2);
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        int n = objectArray.length;
        int n2 = this.size();
        if (n2 > n) {
            Class<?> clazz = objectArray.getClass().getComponentType();
            objectArray = (Object[])Array.newInstance(clazz, n2);
            n = n2;
        }
        int n3 = this.startPos();
        int n4 = 0;
        while ((n3 = this.nextPos(n3)) != 0) {
            objectArray[n4] = this.getPosPrevious(n3);
            ++n4;
        }
        if (n2 < n) {
            objectArray[n2] = null;
        }
        return objectArray;
    }

    public int stableCompare(AbstractSequence abstractSequence) {
        int n;
        int n2 = System.identityHashCode(this);
        return n2 < (n = System.identityHashCode(abstractSequence)) ? -1 : (n2 > n ? 1 : 0);
    }

    public static int compare(AbstractSequence abstractSequence, int n, AbstractSequence abstractSequence2, int n2) {
        if (abstractSequence == abstractSequence2) {
            return abstractSequence.compare(n, n2);
        }
        return abstractSequence.stableCompare(abstractSequence2);
    }

    public int hashCode() {
        int n = 1;
        int n2 = this.startPos();
        while ((n2 = this.nextPos(n2)) != 0) {
            Object object2 = this.getPosPrevious(n2);
            n = 31 * n + (object2 == null ? 0 : object2.hashCode());
        }
        return n;
    }

    public boolean equals(Object object2) {
        Object e;
        Object e2;
        if (!(this instanceof List) || !(object2 instanceof List)) {
            return this == object2;
        }
        Iterator iterator = this.iterator();
        Iterator iterator2 = ((List)object2).iterator();
        do {
            boolean bl;
            boolean bl2;
            if ((bl2 = iterator.hasNext()) != (bl = iterator2.hasNext())) {
                return false;
            }
            if (!bl2) {
                return true;
            }
            e2 = iterator.next();
            e = iterator2.next();
        } while (!(e2 == null ? e != null : !e2.equals(e)));
        return false;
    }

    public Sequence subSequence(SeqPosition seqPosition, SeqPosition seqPosition2) {
        return this.subSequencePos(seqPosition.ipos, seqPosition2.ipos);
    }

    protected Sequence subSequencePos(int n, int n2) {
        return new SubSequence(this, n, n2);
    }

    public List subList(int n, int n2) {
        return new SubSequence(this, this.createPos(n, false), this.createPos(n2, true));
    }

    public boolean consumeNext(int n, Consumer consumer) {
        int n2 = this.nextPos(n);
        if (n2 == 0) {
            return false;
        }
        this.consumePosRange(n, n2, consumer);
        return true;
    }

    public void consumePosRange(int n, int n2, Consumer consumer) {
        if (consumer.ignoring()) {
            return;
        }
        int n3 = this.copyPos(n);
        while (!this.equals(n3, n2)) {
            if (!this.hasNext(n3)) {
                throw new RuntimeException();
            }
            consumer.writeObject(this.getPosNext(n3));
        }
        this.releasePos(n3);
    }

    public void consume(Consumer consumer) {
        String string;
        boolean bl = this instanceof Sequence;
        String string2 = string = "#sequence";
        if (bl) {
            consumer.beginGroup(string, string2);
        }
        this.consumePosRange(this.startPos(), this.endPos(), consumer);
        if (bl) {
            consumer.endGroup(string);
        }
    }

    public void toString(String string, StringBuffer stringBuffer) {
        boolean bl = false;
        int n = this.startPos();
        while ((n = this.nextPos(n)) != 0) {
            if (bl) {
                stringBuffer.append(string);
            } else {
                bl = true;
            }
            stringBuffer.append(this.getPosPrevious(n));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this instanceof Sequence) {
            stringBuffer.append('[');
        }
        this.toString(", ", stringBuffer);
        if (this instanceof Sequence) {
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }
}

