/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.TryState;
import gnu.bytecode.Type;

public class SwitchState {
    int minValue;
    int maxValue;
    int numCases;
    int[] values;
    Label[] labels;
    Label defaultLabel;
    Label switch_label;
    Label cases_label;
    Label after_label;
    TryState outerTry;

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getNumCases() {
        return this.numCases;
    }

    public SwitchState(CodeAttr codeAttr) {
        this.switch_label = new Label(codeAttr);
        this.cases_label = new Label(codeAttr);
        this.after_label = new Label(codeAttr);
        this.outerTry = codeAttr.try_stack;
        this.numCases = 0;
    }

    public void switchValuePushed(CodeAttr codeAttr) {
        codeAttr.popType();
        this.cases_label.setTypes(codeAttr);
        codeAttr.fixupChain(this.cases_label, this.switch_label);
    }

    public boolean addCase(int n, CodeAttr codeAttr) {
        Label label = new Label(codeAttr);
        if (codeAttr.reachableHere()) {
            label.setTypes(this.cases_label);
        } else {
            label.setTypesSame(this.cases_label);
        }
        label.define(codeAttr);
        return this.insertCase(n, label, codeAttr);
    }

    public boolean addCaseGoto(int n, CodeAttr codeAttr, Label label) {
        boolean bl = this.insertCase(n, label, codeAttr);
        label.setTypesSame(this.cases_label);
        codeAttr.setUnreachable();
        return bl;
    }

    public void addDefault(CodeAttr codeAttr) {
        Label label = new Label(codeAttr);
        if (codeAttr.reachableHere()) {
            label.setTypes(this.cases_label);
        } else {
            label.setTypesSame(this.cases_label);
        }
        label.define(codeAttr);
        if (this.defaultLabel != null) {
            throw new Error();
        }
        this.defaultLabel = label;
    }

    public boolean insertCase(int n, Label label, CodeAttr codeAttr) {
        int n2;
        int n3;
        if (this.values == null) {
            this.values = new int[10];
            this.labels = new Label[10];
            this.numCases = 1;
            this.minValue = this.maxValue = n;
            this.values[0] = n;
            this.labels[0] = label;
            return true;
        }
        int[] nArray = this.values;
        Label[] labelArray = this.labels;
        if (this.numCases >= this.values.length) {
            this.values = new int[2 * this.numCases];
            this.labels = new Label[2 * this.numCases];
        }
        if (n < this.minValue) {
            n3 = 0;
            this.minValue = n;
        } else if (n > this.maxValue) {
            n3 = this.numCases;
            this.maxValue = n;
        } else {
            n2 = 0;
            int n4 = this.numCases - 1;
            n3 = 0;
            while (n2 <= n4) {
                n3 = n2 + n4 >>> 1;
                if (nArray[n3] >= n) {
                    n4 = n3 - 1;
                    continue;
                }
                n2 = ++n3;
            }
            if (n == nArray[n3]) {
                return false;
            }
        }
        n2 = this.numCases - n3;
        System.arraycopy(nArray, n3, this.values, n3 + 1, n2);
        System.arraycopy(nArray, 0, this.values, 0, n3);
        this.values[n3] = n;
        System.arraycopy(labelArray, n3, this.labels, n3 + 1, n2);
        System.arraycopy(labelArray, 0, this.labels, 0, n3);
        this.labels[n3] = label;
        ++this.numCases;
        return true;
    }

    public void exitSwitch(CodeAttr codeAttr) {
        if (this.outerTry != codeAttr.try_stack) {
            throw new Error("exitSwitch cannot exit through a try");
        }
        codeAttr.emitGoto(this.after_label);
    }

    public void finish(CodeAttr codeAttr) {
        Object object2;
        if (this.defaultLabel == null) {
            this.defaultLabel = new Label(codeAttr);
            this.defaultLabel.define(codeAttr);
            ClassType classType = ClassType.make("java.lang.RuntimeException");
            codeAttr.emitNew(classType);
            codeAttr.emitDup(classType);
            codeAttr.emitPushString("bad case value!");
            Type[] typeArray = new Type[]{Type.string_type};
            object2 = classType.addMethod("<init>", 1, typeArray, Type.voidType);
            codeAttr.emitInvokeSpecial((Method)object2);
            codeAttr.emitThrow();
        }
        codeAttr.fixupChain(this.switch_label, this.after_label);
        if (this.numCases <= 1) {
            codeAttr.pushType(Type.intType);
            if (this.numCases == 1) {
                if (this.minValue == 0) {
                    codeAttr.emitIfIntEqZero();
                } else {
                    codeAttr.emitPushInt(this.minValue);
                    codeAttr.emitIfEq();
                }
                codeAttr.emitGoto(this.labels[0]);
                codeAttr.emitElse();
                codeAttr.emitGoto(this.defaultLabel);
                codeAttr.emitFi();
            } else {
                codeAttr.emitPop(1);
                codeAttr.emitGoto(this.defaultLabel);
            }
        } else if (2 * this.numCases >= this.maxValue - this.minValue) {
            codeAttr.reserve(13 + 4 * (this.maxValue - this.minValue + 1));
            codeAttr.fixupAdd(2, null);
            codeAttr.put1(170);
            codeAttr.fixupAdd(3, this.defaultLabel);
            codeAttr.PC += 4;
            codeAttr.put4(this.minValue);
            codeAttr.put4(this.maxValue);
            int n = 0;
            for (int i = this.minValue; i <= this.maxValue; ++i) {
                object2 = this.values[n] == i ? this.labels[n++] : this.defaultLabel;
                codeAttr.fixupAdd(3, (Label)object2);
                codeAttr.PC += 4;
            }
        } else {
            codeAttr.reserve(9 + 8 * this.numCases);
            codeAttr.fixupAdd(2, null);
            codeAttr.put1(171);
            codeAttr.fixupAdd(3, this.defaultLabel);
            codeAttr.PC += 4;
            codeAttr.put4(this.numCases);
            for (int i = 0; i < this.numCases; ++i) {
                codeAttr.put4(this.values[i]);
                codeAttr.fixupAdd(3, this.labels[i]);
                codeAttr.PC += 4;
            }
        }
        codeAttr.fixupChain(this.after_label, this.cases_label);
    }
}

