/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.kde.kjas.server.KIOSimpleConnection;
import org.kde.kjas.server.Main;

final class KJASSimpleURLConnection
extends URLConnection {
    private KIOSimpleConnection kioconnection = null;
    private int default_port;

    KJASSimpleURLConnection(URL uRL, int n) {
        super(uRL);
        this.default_port = n;
    }

    public boolean usingProxy() {
        return false;
    }

    public Permission getPermission() throws IOException {
        int n = this.url.getPort();
        if (n < 0) {
            n = this.default_port;
        }
        return new SocketPermission(this.url.getHost() + ":" + n, "connect");
    }

    public void connect() throws IOException {
        if (this.kioconnection != null) {
            return;
        }
        Main.debug("KIO KJASSimpleURLConnection.connection " + this.url);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(this.getPermission());
        }
        this.kioconnection = new KIOSimpleConnection(this.url);
        this.kioconnection.connect(this.doInput);
        this.connected = true;
    }

    public void disconnect() {
        if (this.kioconnection == null) {
            return;
        }
        this.kioconnection.disconnect();
        this.kioconnection = null;
        this.connected = false;
    }

    public InputStream getInputStream() throws IOException {
        this.doInput = true;
        this.doOutput = false;
        if (this.kioconnection == null) {
            this.connect();
        }
        return this.kioconnection.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        this.doInput = false;
        this.doOutput = true;
        if (this.kioconnection == null) {
            this.connect();
        }
        return this.kioconnection.getOutputStream();
    }
}

