/*
    Copyright (c) 2000 David Faure <faure@kde.org>

    This library is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License or ( at
    your option ) version 3 or, at the discretion of KDE e.V. ( which shall
    act as a proxy as in section 14 of the GPLv3 ), any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "plugin_spellcheck.h"

#include <KParts/ReadOnlyPart>
#include <QTextEdit>
#include <QAction>
#include <KActionCollection>
#include <KMessageBox>
#include <KPluginFactory>
#include <KLocalizedString>
#include <QDebug>

PluginSpellCheck::PluginSpellCheck(QObject *parent,
                                   const QVariantList &)
    : Plugin(parent)
{
    QAction *act = new QAction(QStringLiteral("&Select current line (plugin)"), this);
    actionCollection()->addAction(QStringLiteral("spellcheck"), act);
    connect(act, SIGNAL(triggered()), this, SLOT(slotSpellCheck()));
}

PluginSpellCheck::~PluginSpellCheck()
{
}

void PluginSpellCheck::slotSpellCheck()
{
    // qDebug() << "Plugin parent : " << parent()->objectName() << " (" << parent()->metaObject()->className() << ")";
    // The parent is assumed to be a NotepadPart
    // Can't use qobject_cast here, we would need NotepadPart to be in a shared library.
    if (!parent()->inherits("NotepadPart")) {
        KMessageBox::error(nullptr, QStringLiteral("You just called the spell-check action on a wrong part (not NotepadPart)"));
    } else {
        KParts::ReadOnlyPart *part = static_cast<KParts::ReadOnlyPart *>(parent());
        QTextEdit *widget = qobject_cast<QTextEdit *>(part->widget());
        Q_ASSERT(widget);
        widget->selectAll();
    }
}

K_PLUGIN_FACTORY(PluginSpellCheckFactory, registerPlugin<PluginSpellCheck>();)

#include "moc_plugin_spellcheck.cpp"
#include "plugin_spellcheck.moc"
