/*
    Copyright 2018 Billy Laws <blaws05@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) version 3, or any
    later version accepted by the membership of KDE e.V. (or its
    successor approved by the membership of KDE e.V.), which shall
    act as a proxy defined in Section 6 of version 3 of the license.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef NETWORKMANAGERQT_VXLAN_SETTING_P_H
#define NETWORKMANAGERQT_VXLAN_SETTING_P_H

#include <QtCore/QString>

namespace NetworkManager
{

class VxlanSettingPrivate
{
public:
    VxlanSettingPrivate();

    QString name;
    quint32 ageing;
    quint32 destinationPort;
    quint32 id;
    bool l2Miss;
    bool l3Miss;
    bool learning;
    quint32 limit;
    QString local;
    QString parent;
    bool proxy;
    QString remote;
    bool rsc;
    quint32 sourcePortMax;
    quint32 sourcePortMin;
    quint32 tos;
    quint32 ttl;
};

}

#endif // NETWORKMANAGERQT_VXLAN_SETTING_P_H
